% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Links.R
\name{links_ShortenGoogl}
\alias{links_ShortenGoogl}
\title{Given a long URL, returns a short Goo.gl link.}
\usage{
links_ShortenGoogl(longUrl = "", showRequestURL = FALSE)
}
\arguments{
\item{longUrl}{- a long URL to be shortened (example: http://betaworks.com/).}

\item{showRequestURL}{- show URL which has been build and requested from server. For debug purposes.}
}
\value{
id is the short URL that expands to the long URL you provided. If your request includes
an auth token, then this URL will be unique. If not, then it might be reused from a previous
request to shorten the same URL.

longURL - longUrl is the long URL to which it expands. In most cases, this will be the
same as the URL you provided. In some cases, the server may canonicalize the URL. For instance,
if you pass http://www.google.com, the server will add a trailing slash.
}
\description{
Given a full URL, returns an goo.gl short URL. The returned resource contains the
short URL and the long URL. Note that the returned long URL may be loosely canonicalized, e.g.
to convert "google.com" into "http://google.com/". See the Authentication
\link{rbitlyApi} section for more details.
}
\examples{
options(Goo.gl = "AIzaSyAbJt9APfph1JGIhflkoH9UuGhOACntOjw")
g2 <- links_ShortenGoogl(longUrl = "https://developers.google.com/url-shortener/v1/url/insert")
}
\seealso{
See \url{https://developers.google.com/url-shortener/v1/url/insert}

See \url{https://developers.google.com/url-shortener/v1/getting_started#shorten}

See \url{http://stackoverflow.com/a/13168073}
}

