% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO-download.R
\name{processAgilent}
\alias{processAgilent}
\title{Process and normalize agilent-based dataset}
\usage{
processAgilent(dir, samples = NULL, greenOnly)
}
\arguments{
\item{dir}{The path to the directory containing TXT files.}

\item{samples}{A vector of samples IDs. If NULL, the function will automatically detect the samples in the directory.}

\item{greenOnly}{Logical, for use with source, should the green (Cy3) channel only be read, or are both red and green required.}
}
\value{
A matrix of normalized expression data. Rows are probes and columns are samples.
}
\description{
This function process TXT files and normalize expression data
}
\details{
Read and normalize expression data for agilent using limma normexp, loess, and quantile methods
}
\examples{
\donttest{
library(RCPA)
geoId <- "GSE28522"

downloadPath <- file.path(tempdir(), geoId)
fileList <- RCPA::downloadGEO(GEOID = geoId, protocol = "agilent",
                              platform ="GPL4133", destDir = downloadPath)

expression <- RCPA::processAgilent(downloadPath, greenOnly = FALSE)
}

}
