% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tau_min.R
\name{tau_min}
\alias{tau_min}
\title{tau_min() computes the minimum detectable difference between control group and each treatment}
\usage{
tau_min(
  outcome_var,
  N,
  power = 0.8,
  significance = 0.05,
  share_control,
  n_groups = 2
)
}
\arguments{
\item{outcome_var}{the variable for which you wish to test the impact of treatment}

\item{N}{number of observations in the RCT, usually nrow(data)}

\item{power}{The level of power of the test (1 - Pr(Reject H_0 | H_0 True) ). Default is 0.8}

\item{significance}{The level of significance of the test Pr(Reject H_0 | H_0 False). Default is 0.05}

\item{share_control}{The share of observations in N assigned to control. This argument allows for sequences (i.e. seq(0,1,0.1))}

\item{n_groups}{Number of groups (control + # treatment groups)}
}
\value{
A tibble with the share_control and N observations in control group (N_control), 
the share and N of each treatment c(share_ti, N_ti), 
total share of treatment rows and N treated (share_treat, N_treat), N, 
the minimum detectable difference between control and all treatments together (tau_min_global),
the minimum detectable difference between control and each treatment (tau_min_each_treat)
}
\description{
tau_min() computes the minimum detectable difference between control group and each treatment
}
\details{
This function calculates the minimum difference that could show significant 
E[Y(1)-Y(0)] = tau, between any two given groups (e.g. control vs each treatment), given the 
population size (N), the outcome variable, power and significance
}
\examples{
data <- data.frame(y_1 = rbinom(n = 100, size = 1, prob = 0.3), 
                  y_2 = rnorm(n = 100, mean = 8, sd = 2))
tau_min(data$y_1, N = nrow(data), share_control = seq(0,1,0.1), n_groups = 3)
}
