% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiSuccessionPlot}
\alias{MultiSuccessionPlot}
\title{Successive Phases Density Plots (for phases in temporal order constraint)}
\usage{
MultiSuccessionPlot(file, position, level = 0.95, dec = '.', sep=',', comment.char='#',
  title = "Phases marginal posterior densities", GridLength = 1024)
}
\arguments{
  \item{file}{name of the CSV file containing the output of the MCMC algorithm of all phases of interest}
  \item{position}{numeric vector containing the position of the phases of interest in the CSV file}
  \item{level}{probability corresponding to the level of confidence}
  \item{dec}{the character used in the file for decimal points for the use of read.csv()}
  \item{sep}{the field separator character for the use of read.csv()}
  \item{comment.char}{a character vector of length one containing a single character or an empty string for the use of read.csv()}
  \item{title}{title of the graph}
  \item{GridLength}{length of the grid used to estimate the density}
}
\value{
Returns a plot of all densities and adds several summary statistics
}
\description{
This functions draws a plot of the densities of several successive phases and adds several statistics (mean, CI, HPDR)
}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\examples{
  data(Phases)
  write.csv(Phases, "data.csv")
  MultiSuccessionPlot("data.csv", c(4,2), 0.95)
  MultiSuccessionPlot("data.csv", c(4,2), 0.90, title = "Succession of phase 1 and phase 2")
}
\keyword{ marginal posterior density }
\keyword{ gap between two phases }
\keyword{ transition between two phases}
\keyword{ phase time range }
\keyword{ temporal order }
