% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obce_polygony.R
\name{obce_polygony}
\alias{obce_polygony}
\title{Municipalities / communes (obce) as polygons}
\format{sf data frame with 6.258 rows of 14 variables + geometry

\describe{
  \item{KOD_OBEC}{Code of the level I commune (obec).}
  \item{NAZ_OBEC}{Name of the level I commune (obec).}
  \item{KOD_ZUJ}{Code of the basic administrative unit (ICZUJ).}
  \item{NAZ_ZUJ}{Name of the basic administrative unit (ICZUJ).}
  \item{KOD_POU}{Code of the level II commune (obec s poverenym uradem).}
  \item{NAZ_POU}{Name of the level II commune (obec s poverenym uradem)).}
  \item{KOD_ORP}{Code of the level III commune (obec s rozsirenou pusobnosti).}
  \item{NAZ_ORP}{Name of the level III commune (obec s rozsirenou pusobnosti).}
  \item{KOD_OKRES}{Code of the district (okres).}
  \item{KOD_LAU1}{Code of the LAU1 administrative unit (okres).}
  \item{NAZ_LAU1}{Name of the LAU1 administrative unit (okres).}
  \item{KOD_KRAJ}{Code of the region (kraj).}
  \item{KOD_CZNUTS2}{Code of the NUTS3 unit (kraj)}
  \item{NAZ_CZNUTS2}{Name of the NUTS3 unit (kraj)}
}}
\source{
\url{https://www.arcdata.cz/produkty/geograficka-data/arccr-500}
}
\usage{
obce_polygony()
}
\description{
LAU2 administrative unit for the Czech Republic.
}
\details{
Due to package size constraints the data are stored externally (and a working internet connection is required to use the package). Downloaded size is 36.3 MB (so use with caution, and patience).

obce_polygony() is a function taking no parameters and returning a data frame; remember to use (empty) brackets in your call.
}
\examples{
\dontrun{
praha <- obce_polygony() \%>\%
   filter(NAZ_LAU1 == "Praha")

plot(praha, max.plot = 1)
}


}
