% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds.data.frame.R
\name{as.rds.data.frame}
\alias{as.rds.data.frame}
\title{Coerces a data.frame object into an rds.data.frame object.}
\usage{
as.rds.data.frame(df, id = if (is.null(attr(df, "id"))) "id" else
  attr(df, "id"), recruiter.id = if (is.null(attr(df, "recruiter.id"))) {
      "recruiter.id" } else attr(df, "recruiter.id"), network.size = if
  (is.null(attr(df, "network.size.variable"))) {    
  "network.size.variable" } else attr(df, "network.size.variable"),
  population.size = if (all(is.na(get.population.size(df, FALSE)))) {    
  NULL } else get.population.size(df, FALSE), max.coupons = if
  (is.null(attr(df, "max.coupons"))) {     NULL } else attr(df,
  "max.coupons"), notes = if (is.null(attr(df, "notes"))) {     NULL }
  else attr(df, "time"), time = if (is.null(attr(df, "time"))) {     NULL
  } else attr(df, "time"), check.valid = TRUE)
}
\arguments{
\item{df}{A data.frame representing an RDS sample.}

\item{id}{The unique identifier.}

\item{recruiter.id}{The unique identifier of the recruiter of this row.}

\item{network.size}{The number of alters (i.e. possible recruitees).}

\item{population.size}{The size of the population from which this RDS sample 
has been drawn. Either a single number, or a vector of length three indicating low, mid 
and high estimates.}

\item{max.coupons}{The number of recruitment coupons distributed to each 
enrolled subject (i.e. the maximum number of recruitees for any subject).}

\item{notes}{Data set notes.}

\item{time}{the name of the recruitment time variable. optional.}

\item{check.valid}{If true, validity checks are performed to ensure that the data is well formed.}
}
\value{
An rds.data.frame object
}
\description{
This function converts a regular R data frame into an  
\code{rds.data.frame}.  The greatest advantage of this is that it 
performs integrity checks and will fail if the recruitment information 
in the original data frame is incomplete.
}
\examples{
dat <- data.frame(id=c(1,2,3,4,5), recruiter.id=c(2,-1,2,-1,4),
                  network.size.variable=c(4,8,8,2,3))
as.rds.data.frame(dat)

}
