% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Gompertzmix.R
\name{Gompertzmix}
\alias{Gompertzmix}
\title{NPMLE for Gompertz Mixtures}
\usage{
Gompertzmix(x, v = 300, u = 300, alpha, theta, hist = FALSE,
  weights = NULL, ...)
}
\arguments{
\item{x}{Survival times}

\item{v}{Grid values for mixing distribution}

\item{u}{Grid values for mixing distribution}

\item{alpha}{Shape parameter for Gompertz distribution}

\item{theta}{Scale parameter for Gompertz Distribution}

\item{hist}{If TRUE aggregate to histogram counts}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{optional parameters passed to KWDual to control optimization}
}
\value{
An object of class density with components
	\item{x}{points of evaluation on the domain of the density}
	\item{y}{estimated function values at the points x, the mixing density}
	\item{logLik}{Log likelihood value at the proposed solution}
	\item{dy}{Bayes rule estimates of theta at observed x}
	\item{status}{exit code from the optimizer}
}
\description{
Kiefer-Wolfowitz NPMLE for Gompertz Mixtures of scale parameter
}
\details{
Kiefer Wolfowitz NPMLE density estimation for Gompertz scale mixtures. The
histogram option is intended for relatively large problems, say n > 1000,
where reducing the sample size dimension is desirable. By default the grid
for the binning is equally spaced on the support of the data.
Parameterization: f(t|alpha,theta,v) = theta * exp(v) * exp(alpha * t) *
         exp(-(theta/alpha) * exp(v) * (exp(alpha*t)-1))
}
\author{
Roger Koenker and Jiaying Gu
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}. Volume 27, Number 4 (1956), 887-906.
}
\seealso{
\code{Weibullmix}
}
\keyword{nonparametric}

