% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tncpmix.R
\name{Tncpmix}
\alias{Tncpmix}
\title{NPMLE for Student t non-centrality parameter mixtures}
\usage{
Tncpmix(x, v = 300, u = 300, df = 1, hist = FALSE, weights = NULL,
  ...)
}
\arguments{
\item{x}{Data: Sample Observations}

\item{v}{bin boundaries defaults to equal spacing of length v}

\item{u}{bin boundaries for histogram binning: defaults to equal spacing}

\item{df}{Number of degrees of freedom of Student base density}

\item{hist}{If TRUE then aggregate x to histogram weights}

\item{weights}{replicate weights for x obervations, should sum to 1}

\item{...}{optional parameters passed to KWDual to control optimization}
}
\value{
An object of class density with components: 
	\item{x}{midpoints of evaluation on the domain of the mixing density} 
	\item{y}{estimated function values at the points x of the mixing density} 
	\item{g}{estimated function values at the observed points of mixture density} 
	\item{logLik}{Log likelihood value at the proposed solution} 
	\item{dy}{Bayes rule estimates of location at x} 
	\item{status}{Mosek exit code}
}
\description{
Kiefer Wolfowitz NPMLE for Student t non-centrality parameter mixtures
Model: \eqn{y_{ig} = mu_{g} + e_{ig}, e_{ig} ~ N(0,sigma_{g}^{2})}
x is the vector of t statistics for all groups, which follows t dist
if \eqn{mu_g = 0}, and noncentral t dist if \eqn{mu_g \neq 0}, 
with \eqn{ncp_{g} = \mu_g / \sigma_{g}}.
This leads to a mixture of t distribution with ncp as the mixing parameter.  
df (degree of freedom) is determined by the group size in the simplest case.
}
\references{
Kiefer, J. and J. Wolfowitz Consistency of the Maximum
Likelihood Estimator in the Presence of Infinitely Many Incidental
Parameters \emph{Ann. Math. Statist}.  27, (1956), 887-906.

Koenker, R. and J. Gu, (2017) REBayes: An {R} Package for Empirical Bayes Mixture Methods,
\emph{Journal of Statistical Software}, 82, 1--26.
}
\seealso{
GLmix for Gaussian version
}
\author{
Roger Koenker
}
\keyword{nonparametric}
