% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_event.R
\name{rd_event}
\alias{rd_event}
\title{Identification of missing event/s}
\usage{
rd_event(
  ...,
  data = NULL,
  dic = NULL,
  event,
  filter = NA,
  query_name = NA,
  addTo = NA,
  report_title = NA,
  report_zeros = FALSE,
  link = list()
)
}
\arguments{
\item{...}{List containing the data and the dictionary and the event if it's needed. Can be the output of the function `redcap_data`.}

\item{data}{Data frame containing data from REDCap. If the list is specified this argument is not needed.}

\item{dic}{Data frame containing the dictionary read from REDCap. If the list is specified this argument is not needed.}

\item{event}{Vector with the REDCap's events names to be analyzed.}

\item{filter}{A filter to apply to the dataset. This argument can be used to identify the missing events on a subgroup of the dataset.}

\item{query_name}{Description of the query. It can be defined as the same one for all events or you can define one for each event By default, the function will define the description as `The event [event] is missing' for each event`.}

\item{addTo}{Data frame corresponding to a prior report of queries to which you can add the new data frame of queries. By default, the function will always generate a new data frame without taking into account former reports.}

\item{report_title}{Character string with the report's title.}

\item{report_zeros}{Logical. If `TRUE`, it returns a report including events with zero queries.}

\item{link}{List containing project information used to create a web link to each query.}
}
\value{
A dataframe with 9 columns meant to help the user identify each missing event and a table with the total of queries per variable.
}
\description{
When working with a longitudinal REDCap project, the exported data has a structure where each row represents one event per record. However, by default, REDCap will not export events that do not have information.
This function allows you to point out which record identifiers do not have information of a determined event.
}
\examples{
example <- rd_event(covican,
                    event = "follow_up_visit_da_arm_1")
example
}
