/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.multiobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.DominanceMinComparator;
import javalain.math.Calcul;
import javalain.math.fonction.Fct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZDT6
extends Fct {
    private static final double cte = Math.PI * 6;

    public ZDT6() {
        this(10);
    }

    public ZDT6(int nbVariable) {
        this.nomFct = "ZDT6";
        this.nbVariable = nbVariable;
        this.nbFctObjectif = 2;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = 0.0;
            this.upperLimit[i] = 1.0;
        }
    }

    @Override
    public double[] compute(double[] x) {
        double[] fct = new double[this.nbFctObjectif];
        double g = ZDT6.g(x);
        fct[0] = 1.0 - Math.exp(-4.0 * x[0]) * Calcul.pow6(Math.sin(Math.PI * 6 * x[0]));
        fct[1] = g * ZDT6.f(fct[0], g);
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.readParetoFront("ZDT6.pf");
        }
        return this.front;
    }

    private static double g(double[] x) {
        double somme = 0.0;
        for (int i = 1; i < x.length; ++i) {
            somme += x[i];
        }
        return 1.0 + 9.0 * Math.pow(somme / (double)(x.length - 1), 0.25);
    }

    private static double f(double f1, double g) {
        return 1.0 - Calcul.pow2(f1 / g);
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new DominanceMinComparator();
    }
}

