/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.stoppingcriterion.AbstractGenerationStoppingCriterion;

public class FitnessBound
extends AbstractGenerationStoppingCriterion
implements GenerationEventListener {
    private double range;
    private boolean max = true;
    private boolean all;

    public FitnessBound(Schedule schedule) {
        super(schedule);
        try {
            this.range = ((SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).getUpperBound();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public String getName() {
        return "Fitness Bound";
    }

    public String getDescription() {
        return "Stops a run if the specified fitness bound is reached.";
    }

    public void setPropertyBound(Double range) {
        this.range = range;
    }

    public Double getPropertyBound() {
        return new Double(this.range);
    }

    public void setPropertyMaximize(Boolean max) {
        this.max = max;
    }

    public Boolean getPropertyMaximize() {
        return new Boolean(this.max);
    }

    public String getLongDescriptionForBound() {
        return "A fitness bound that has to be passed to stop the run.";
    }

    public String getShortDescriptionForMaximize() {
        return "Maximization problem";
    }

    public String getLongDescriptionForMaximize() {
        return "Specifies whether a maximization problem is processed or a minimization problem.";
    }

    public void checkCriterion(GenerationEvent evt) {
        try {
            double fitness;
            IndividualList population = this.getSchedule().getPopulationManager().getPopulation();
            SingleObjectiveFitnessFunction fitnessFunction = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
            if (!this.all) {
                Individual fittest = population.getIndividualWithRank(1);
                fitness = fitnessFunction.evaluate(fittest, population);
            } else {
                Individual worst = population.getIndividualWithRank(population.size());
                fitness = fitnessFunction.evaluate(worst, population);
            }
            if (this.max) {
                if (fitness >= this.range) {
                    this.stopRun();
                }
            } else if (fitness <= this.range) {
                this.stopRun();
            }
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException("The stopping criterion can't be applied since the fitness function doesn't know its optimum.");
        }
    }

    public void setPropertyAll(Boolean all) {
        this.all = all;
    }

    public Boolean getPropertyAll() {
        return new Boolean(this.all);
    }

    public String getShortDescriptionForAll() {
        return "Whole population";
    }

    public String getLongDescriptionForAll() {
        return "If unchecked, the run is stopped as soon as one individual reaches the specified fitness bound.\nIf checked, all individuals have to reached the specified fitness bound.";
    }
}

