/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.demo;

class MandelbrotSet {
    double x;
    double y;
    double edge;
    int resolution;
    int limit;
    int colorBits;
    MandelbrotSet previous;
    MandelbrotSet next;

    public MandelbrotSet() {
        this.x = -2.0;
        this.y = -1.25;
        this.edge = 2.5;
        this.resolution = 128;
        this.colorBits = 1;
        this.limit = 1 << 3 * this.colorBits;
    }

    public MandelbrotSet(MandelbrotSet mandelbrotSet) {
        this.x = mandelbrotSet.x;
        this.y = mandelbrotSet.y;
        this.edge = mandelbrotSet.edge;
        this.resolution = mandelbrotSet.resolution;
        this.colorBits = mandelbrotSet.colorBits;
        this.limit = 1 << 3 * this.colorBits;
    }

    void move(int n) {
        switch (n) {
            case 1: {
                this.edge /= 2.0;
                this.x += this.edge / 2.0;
                this.y += this.edge / 2.0;
                break;
            }
            case 2: {
                this.x -= this.edge / 2.0;
                this.y -= this.edge / 2.0;
                this.edge *= 2.0;
            }
        }
    }

    void recenter(int n, int n2) {
        this.x += this.edge * ((double)n / (double)this.resolution);
        this.x -= this.edge / 2.0;
        this.y += this.edge * ((double)n2 / (double)this.resolution);
        this.y -= this.edge / 2.0;
    }

    void reset() {
        this.x = -2.0;
        this.y = -1.25;
        this.edge = 2.5;
    }

    void setResolution(int n) {
        this.resolution = 1 << n;
    }

    void setColorBits(int n) {
        this.colorBits = n;
        this.limit = 1 << 3 * n;
    }

    public String toString() {
        return "x: " + this.x + ", y: " + this.y + ", edge: " + this.edge + ", res: " + this.resolution + ", bits: " + this.colorBits;
    }
}

