/*
 * Decompiled with CFR 0.152.
 */
package freak.module.populationmanager;

import freak.core.control.Schedule;
import freak.core.graph.GraphException;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.NoSuchIndividualException;
import freak.core.population.Population;
import freak.core.populationmanager.AbstractPopulationManager;
import java.util.Iterator;

public class ParallelMultistarts
extends AbstractPopulationManager {
    public ParallelMultistarts(Schedule schedule) {
        super(schedule);
    }

    public void createNewGeneration() throws GraphException, NoSuchIndividualException {
        if (this.getPopulation().isEmpty()) {
            throw new NoSuchIndividualException("Population is empty.");
        }
        Iterator iter = this.getPopulation().iterator();
        this.setPopulation(new Population(this.getSchedule()));
        while (iter.hasNext()) {
            Individual individual = (Individual)iter.next();
            IndividualList result = this.getSchedule().getOperatorGraph().process(new Population(this.getSchedule(), individual));
            this.getPopulation().addAllIndividuals(result);
        }
        this.fireIndividualList(this.getPopulation());
    }

    public String getDescription() {
        return "Parallel independent multistarts of populations with size 1.";
    }

    public String getName() {
        return "Parallel Multistarts";
    }
}

