/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.MultiObjectiveFitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakSmallTableModel;
import freak.core.view.swingsupport.FreakTableModel;
import freak.core.view.swingsupport.UpdateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class IndividualTable
extends AbstractView {
    private FreakTableModel model = new FreakSmallTableModel(new String[]{"Date of Birth", "Fitness", "Genotype"});

    public IndividualTable(Schedule schedule) {
        super(schedule);
    }

    public JPanel createPanel() {
        JTable table = new JTable();
        JScrollPane scrollPane = new JScrollPane(table);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)scrollPane, "Center");
        this.model.setView(table);
        return panel;
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object data) {
        super.update(data);
        FitnessFunction fitness = this.getSchedule().getFitnessFunction();
        boolean singleObjective = fitness instanceof SingleObjectiveFitnessFunction;
        IndividualList individuals = (IndividualList)data;
        Iterator i = individuals.iterator();
        FreakTableModel freakTableModel = this.model;
        synchronized (freakTableModel) {
            this.model.clear();
            while (i.hasNext()) {
                Individual individual = (Individual)i.next();
                String s = "";
                if (singleObjective) {
                    s = new Double(((SingleObjectiveFitnessFunction)fitness).evaluate(individual, individuals)).toString();
                } else {
                    double[] result = ((MultiObjectiveFitnessFunction)fitness).evaluate(individual, individuals);
                    s = " , ";
                    int j = 0;
                    while (j < result.length) {
                        s = String.valueOf(s) + result[j];
                        if (j < result.length - 1) {
                            s = String.valueOf(s) + " , ";
                        }
                        ++j;
                    }
                    s = String.valueOf(s) + " , ";
                }
                this.model.addRow(new Object[]{new Integer(individual.getDateOfBirth()), s, individual.getGenotype()});
            }
        }
        UpdateManager.markDirty(this.model);
    }

    public String getName() {
        return "Individual Table";
    }

    public String getDescription() {
        return "Shows a table of all individuals with their genotypes, fitness values and dates of birth.";
    }
}

