/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.RunIndex;
import java.io.Serializable;

public class GenerationIndex
implements Comparable,
Serializable {
    public static final GenerationIndex START = new GenerationIndex(0, 0, 0);
    public static final GenerationIndex FIRST = new GenerationIndex(1, 1, 1);
    public static final GenerationIndex LAST = new GenerationIndex(0x7FFFFFFE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final GenerationIndex END = new GenerationIndex(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public final int batch;
    public final int run;
    public final int generation;

    public GenerationIndex(int batch, int run, int generation) {
        this.batch = batch;
        this.run = run;
        this.generation = generation;
    }

    public RunIndex toRunIndex() {
        return new RunIndex(this.batch, this.run);
    }

    public GenerationIndex nextGeneration() {
        if (this.batch == 0) {
            return new GenerationIndex(1, 1, 1);
        }
        if (this.run == Integer.MAX_VALUE) {
            return new GenerationIndex(this.batch + 1, 1, 1);
        }
        if (this.generation == Integer.MAX_VALUE) {
            return new GenerationIndex(this.batch, this.run + 1, 1);
        }
        return new GenerationIndex(this.batch, this.run, this.generation + 1);
    }

    public GenerationIndex nextRunStart() {
        if (this.batch == 0) {
            return new GenerationIndex(1, 1, 1);
        }
        if (this.run == Integer.MAX_VALUE) {
            return new GenerationIndex(this.batch + 1, 1, 1);
        }
        return new GenerationIndex(this.batch, this.run + 1, 1);
    }

    public GenerationIndex nextBatchStart() {
        if (this.batch == 0) {
            return new GenerationIndex(1, 1, 1);
        }
        return new GenerationIndex(this.batch + 1, 1, 1);
    }

    public GenerationIndex runStart() {
        if (this.batch == 0) {
            return START;
        }
        return new GenerationIndex(this.batch, this.run, 1);
    }

    public GenerationIndex batchStart() {
        if (this.batch == 0) {
            return START;
        }
        return new GenerationIndex(this.batch, 1, 1);
    }

    public boolean isBefore(Object other) {
        return this.compareTo(other) < 0;
    }

    public boolean isAfter(Object other) {
        return this.compareTo(other) > 0;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof GenerationIndex)) {
            return false;
        }
        return this.compareTo(other) == 0;
    }

    public int compareTo(Object other) throws ClassCastException, NullPointerException {
        GenerationIndex t = (GenerationIndex)other;
        if (this.batch != t.batch) {
            return this.batch - t.batch;
        }
        if (this.run != t.run) {
            return this.run - t.run;
        }
        return this.generation - t.generation;
    }

    public int hashCode() {
        return this.batch + this.run + this.generation;
    }

    public String toString() {
        return "Batch: " + this.batch + ", Run: " + this.run + ", Generation: " + this.generation;
    }
}

