/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.matching;

import edu.ucsb.cs.jicos.applications.branchandbound.BranchAndBound;
import edu.ucsb.cs.jicos.applications.branchandbound.Solution;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.matching.Edge;
import edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.matching.Path;
import edu.ucsb.cs.jicos.applications.utilities.graph.Graph;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphEuclidean;
import edu.ucsb.cs.jicos.applications.utilities.graph.GraphImpl;
import edu.ucsb.cs.jicos.examples.tsp.TSP;
import edu.ucsb.cs.jicos.examples.tsp.TspSolution;
import edu.ucsb.cs.jicos.services.Client2Hsp;
import edu.ucsb.cs.jicos.services.Environment;
import edu.ucsb.cs.jicos.services.HspAgent;
import edu.ucsb.cs.jicos.services.shared.IntUpperBound;
import java.util.Iterator;
import java.util.List;

public final class Matching {
    private static final int K = 4;
    private static final int DUMMY_DISTANCE = 1000000;
    private int[][] distances;
    private int dummyIndex;
    private boolean[][][] endpointIsI;
    private boolean hasDummy;
    private Path[] paths;
    private int[][] pathDistances;
    private int problemSize;
    private int[] tour;
    private int tourSize;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$matching$Matching;

    void endpointIsI(boolean[][][] blArray) {
        this.endpointIsI = blArray;
    }

    public Matching(int[][] nArray) {
        if (nArray.length < 3) {
            throw new IllegalArgumentException("distances.length must be > 2.");
        }
        this.tour = new int[nArray.length];
        this.tourSize = nArray.length;
        this.dummyIndex = nArray.length;
        int n = nArray.length + 1;
        this.distances = new int[n][n];
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray.length) {
                this.distances[n2][n3] = nArray[n2][n3];
                ++n3;
            }
            this.distances[n2][this.dummyIndex] = 1000000;
            this.distances[this.dummyIndex][n2] = 1000000;
            ++n2;
        }
        this.distances[this.dummyIndex][this.dummyIndex] = 0;
        this.problemSize = nArray.length;
        if (nArray.length % 2 == 1 && nArray.length > 4) {
            this.hasDummy = true;
            ++this.problemSize;
        }
    }

    public int[] getTour() {
        return this.tour;
    }

    public void setTour() {
        this.initializeMatchProblem();
        while (this.problemSize > 4) {
            GraphImpl graphImpl = new GraphImpl(this.pathDistances);
            int[] nArray = graphImpl.getMinCostMaxMatch();
            this.connectMatedPaths(nArray);
            this.setNextMatchProblem();
        }
        if (!$assertionsDisabled && this.problemSize > 4) {
            throw new AssertionError();
        }
        this.tour = this.minCostTour();
    }

    boolean[][][] endpointIsI() {
        return this.endpointIsI;
    }

    private void connectMatedPaths(int[] nArray) {
        int n;
        int n2 = 0;
        while (n2 < nArray.length) {
            if (!(n2 >= nArray[n2] || this.hasDummy && nArray[n2] == nArray.length - 1)) {
                this.paths[n2].add(this.paths[nArray[n2]]);
                n = this.distances[n2][nArray[n2]];
                this.paths[n2].addCost(n);
            }
            ++n2;
        }
        n = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (n3 < nArray[n3]) {
                this.paths[n] = this.paths[n3];
                this.paths[n].index(n++);
            }
            ++n3;
        }
        if (!$assertionsDisabled && n != nArray.length / 2) {
            throw new AssertionError();
        }
        this.problemSize /= 2;
    }

    private void copyPath2Tour(List list, int[] nArray, int n) {
        Iterator iterator = list.iterator();
        int n2 = n;
        while (iterator.hasNext()) {
            nArray[n2] = (Integer)iterator.next();
            ++n2;
        }
    }

    private int[] expandSkeleton(int[] nArray, Orientation orientation) {
        int[] nArray2 = new int[this.tourSize];
        int n = orientation.getOrientations();
        int n2 = 0;
        int n3 = 0;
        while (n2 < nArray.length) {
            Path path = this.paths[nArray[n2]];
            List list = n % 2 == 0 ? path.list() : path.reverse();
            this.copyPath2Tour(list, nArray2, n3);
            n3 += list.size();
            n >>= 1;
            ++n2;
        }
        return nArray2;
    }

    private Orientation getMinPathOrientation(int[] nArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            n += this.paths[n2].cost();
            ++n2;
        }
        int n3 = 1;
        int n4 = 0;
        while (n4 < nArray.length) {
            n3 *= 2;
            ++n4;
        }
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n3) {
            int n8 = n;
            int n9 = n7 % 2 == 0 ? this.paths[nArray[0]].i() : this.paths[nArray[0]].j();
            int n10 = n7 % 2 == 0 ? this.paths[nArray[0]].j() : this.paths[nArray[0]].i();
            int n11 = 1;
            int n12 = n7 >> 1;
            while (n11 < nArray.length) {
                int n13 = this.paths[nArray[n11]].i();
                int n14 = this.paths[nArray[n11]].j();
                int n15 = n12 % 2 == 0 ? n13 : n14;
                n8 += this.distances[n10][n15];
                n10 = n12 % 2 == 0 ? n14 : n13;
                ++n11;
                n12 >>= 1;
            }
            if ((n8 += this.distances[n10][n9]) < n5) {
                n5 = n8;
                n6 = n7;
            }
            ++n7;
        }
        return new Orientation(n6, n5);
    }

    private void initializeMatchProblem() {
        this.initializePaths();
        this.pathDistances = new int[this.problemSize][this.problemSize];
        this.initializePathDistances(this.pathDistances, this.endpointIsI);
    }

    private void initializePathDistances(int[][] nArray, boolean[][][] blArray) {
        int n = 0;
        while (n < this.problemSize) {
            int n2 = n + 1;
            while (n2 < this.problemSize) {
                Edge edge = this.minEdgeBetweenPaths(this.paths[n], this.paths[n2]);
                nArray[n][n2] = edge.cost();
                nArray[n2][n] = edge.cost();
                blArray[n][n2][0] = edge.i();
                blArray[n][n2][1] = edge.j();
                blArray[n2][n][0] = edge.j();
                blArray[n2][n][1] = edge.i();
                ++n2;
            }
            ++n;
        }
    }

    private void initializePaths() {
        this.endpointIsI = new boolean[this.problemSize][this.problemSize][2];
        this.paths = new Path[this.distances.length];
        int n = 0;
        while (n < this.distances.length) {
            this.paths[n] = new Path(this, n);
            ++n;
        }
    }

    private int[] minCostTour() {
        if (!($assertionsDisabled || 2 < this.problemSize && this.problemSize <= 4)) {
            throw new AssertionError();
        }
        switch (this.problemSize) {
            case 3: {
                return this.tour3();
            }
            case 4: {
                return this.tour4();
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return new int[0];
    }

    private Edge minEdgeBetweenPaths(Path path, Path path2) {
        boolean bl;
        boolean bl2;
        int n = this.distances[path.i()][path2.i()];
        int n2 = this.distances[path.i()][path2.j()];
        int n3 = this.distances[path.j()][path2.i()];
        int n4 = this.distances[path.j()][path2.j()];
        int n5 = n;
        if (n2 < n5) {
            n5 = n2;
        }
        if (n3 < n5) {
            n5 = n3;
        }
        if (n4 < n5) {
            n5 = n4;
        }
        if (n5 == n) {
            bl2 = true;
            bl = true;
        } else if (n5 == n2) {
            bl2 = true;
            bl = false;
        } else if (n5 == n3) {
            bl2 = false;
            bl = true;
        } else {
            bl2 = false;
            bl = false;
        }
        return new Edge(n5, bl2, bl);
    }

    private void setNextMatchProblem() {
        if (this.problemSize % 2 == 0 || this.problemSize <= 4) {
            this.hasDummy = false;
        } else {
            this.hasDummy = true;
            this.paths[this.problemSize] = this.paths[this.dummyIndex];
            ++this.problemSize;
        }
        int[][] nArray = new int[this.problemSize][this.problemSize];
        boolean[][][] blArray = new boolean[this.problemSize][this.problemSize][2];
        this.initializePathDistances(nArray, blArray);
        this.pathDistances = nArray;
        this.endpointIsI = blArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Matching tour: ");
        int n = 0;
        while (n < this.tour.length) {
            stringBuffer.append(this.tour[n]);
            stringBuffer.append(" ");
            ++n;
        }
        return new String(stringBuffer);
    }

    private int[] tour3() {
        int[] nArray = new int[]{0, 1, 2};
        Orientation orientation = this.getMinPathOrientation(nArray);
        return this.expandSkeleton(nArray, orientation);
    }

    private int[] tour4() {
        int[] nArray = new int[]{0, 1, 2, 3};
        Orientation orientation = this.getMinPathOrientation(nArray);
        int n = orientation.getCost();
        int[] nArray2 = new int[]{0, 1, 3, 2};
        Orientation orientation2 = this.getMinPathOrientation(nArray2);
        int n2 = orientation.getCost();
        int[] nArray3 = new int[]{0, 2, 1, 3};
        Orientation orientation3 = this.getMinPathOrientation(nArray3);
        int n3 = orientation.getCost();
        if (n <= n2) {
            if (n <= n3) {
                return this.expandSkeleton(nArray, orientation);
            }
            return this.expandSkeleton(nArray3, orientation3);
        }
        if (n2 < n3) {
            return this.expandSkeleton(nArray2, orientation2);
        }
        return this.expandSkeleton(nArray3, orientation3);
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[0]);
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        Matching.compareToMatching(n, n2, n3, true);
    }

    private static void compareToMatching(int n, int n2, int n3, boolean bl) throws Exception {
        if (bl) {
            System.out.println("Random GENERAL graphs.");
        } else {
            System.out.println("Random EUCLIDEAN graphs.");
        }
        System.out.println("\tNodes\tMatch\tTime\tOPT\tTime\tMatching/Opt");
        float f = 0.0f;
        String string = "lysander";
        HspAgent hspAgent = new HspAgent(string);
        Client2Hsp client2Hsp = hspAgent.getClient2Hsp();
        int n4 = n;
        while (n4 <= n2) {
            int n5;
            int n6 = n5 = n4;
            int n7 = 1000;
            Graph graph = bl ? new GraphImpl(n5, n6, n7) : new GraphEuclidean(n5, n6, n7);
            int[][] nArray = graph.getCosts();
            System.out.print("\t" + n4);
            Matching matching = new Matching(nArray);
            long l = System.currentTimeMillis();
            matching.setTour();
            long l2 = System.currentTimeMillis();
            int[] nArray2 = matching.getTour();
            int n8 = Matching.getCost(nArray2, nArray);
            System.out.print("\t" + n8 + "\t" + (l2 - l));
            TSP tSP = new TSP(graph);
            IntUpperBound intUpperBound = new IntUpperBound(n8);
            Environment environment = new Environment(tSP, intUpperBound);
            TspSolution tspSolution = new TspSolution(n5);
            BranchAndBound branchAndBound = new BranchAndBound(tspSolution);
            client2Hsp.login(environment);
            l = System.currentTimeMillis();
            Solution solution = (Solution)client2Hsp.compute(branchAndBound);
            l2 = System.currentTimeMillis();
            if (solution == null) {
                System.out.println("\tNULL");
            } else {
                int n9 = ((TspSolution)solution).getCost();
                System.out.print("\t" + n9 + "\t" + (l2 - l));
                float f2 = (float)n8 / (float)n9;
                System.out.println("\t" + f2);
            }
            client2Hsp.logout();
            n4 += n3;
        }
    }

    private static int getCost(int[] nArray, int[][] nArray2) {
        int n = 0;
        int n2 = nArray[0];
        int n3 = 1;
        while (n3 < nArray.length) {
            n += nArray2[n2][nArray[n3]];
            n2 = nArray[n3];
            ++n3;
        }
        return n += nArray2[n2][nArray[0]];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$matching$Matching == null ? (class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$matching$Matching = Matching.class$("edu.ucsb.cs.jicos.applications.branchandbound.tsp.utilities.upperbounds.matching.Matching")) : class$edu$ucsb$cs$jicos$applications$branchandbound$tsp$utilities$upperbounds$matching$Matching).desiredAssertionStatus();
    }

    private class Orientation {
        private int orientations;
        private int cost;

        Orientation(int n, int n2) {
            this.orientations = n;
            this.cost = n2;
        }

        int getCost() {
            return this.cost;
        }

        int getOrientations() {
            return this.orientations;
        }
    }
}

