% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rgcca.R
\name{plot.rgcca}
\alias{plot.rgcca}
\title{Plot for RGCCA}
\usage{
\method{plot}{rgcca}(
  x,
  type = "weights",
  block = seq_along(x$call$blocks),
  comp = c(1, 2),
  response = as.factor(rep(1, NROW(x$Y[[1]]))),
  display_order = TRUE,
  title = NULL,
  cex = 1,
  cex_sub = 12 * cex,
  cex_main = 14 * cex,
  cex_lab = 12 * cex,
  cex_point = 3 * cex,
  n_mark = 30,
  sample_colors = NULL,
  sample_shapes = NULL,
  var_colors = NULL,
  var_shapes = NULL,
  AVE_colors = NULL,
  show_sample_names = TRUE,
  show_var_names = TRUE,
  repel = FALSE,
  display_blocks = seq_along(x$call$blocks),
  expand = 1,
  show_arrows = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted RGCCA object (see \code{\link[RGCCA]{rgcca}})}

\item{type}{A character string: 'samples', 'weights', 'loadings',
'cor_circle', both', 'biplot' , 'ave' (see details).}

\item{block}{A numeric corresponding to the block(s) to plot.}

\item{comp}{A numeric vector indicating the component(s) to consider.}

\item{response}{A vector coloring the points in the "samples" plot.}

\item{display_order}{A logical value for ordering the variables. If TRUE,
variables are ordered from highest to lowest absolute value. If FALSE,
the block order is used. Default is TRUE.}

\item{title}{A string specifying the title of the plot.}

\item{cex}{A numeric defining the size of the objects in the plot. Default
is one.}

\item{cex_sub}{A numeric defining the font size of the subtitle. Default is
12 * cex.}

\item{cex_main}{A numeric defining the font size of the title. Default is
14 * cex.}

\item{cex_lab}{A numeric defining the font size of the labels. Default is
12 * cex.}

\item{cex_point}{A numeric defining the font size of the points. Default is
3 * cex.}

\item{n_mark}{An integer defining the maximum number of bars plotted in the
"weights" and "loadings" plots. Default is 30.}

\item{sample_colors}{A string specifying the colors used to color samples
(used in the "samples" and "biplot" plots).}

\item{sample_shapes}{Shapes used for the sample points (used in the "samples"
and "biplot" plots).}

\item{var_colors}{Colors used to color variable weights or correlations
with canonical components (used in the "weights", "loadings", "cor_circle"
and "biplot" plots).}

\item{var_shapes}{Shapes used for the points associated to variable weights
or correlations with canonical components (used in the "cor_circle" and
"biplot" plots).}

\item{AVE_colors}{Colors used in the AVE plot.}

\item{show_sample_names}{A logical value for showing the sample names in
plots "samples" and "biplot".}

\item{show_var_names}{A logical value for showing the variable names in
plots "cor_circle" and "biplot".}

\item{repel}{A logical value for repelling text labels from each other.
Default to FALSE.}

\item{display_blocks}{A numeric corresponding to the block(s) to display in
the correlation_circle. All blocks are displayed by default.}

\item{expand}{A numeric that scales the weights associated to the block
variables in the biplot. Default is 1.}

\item{show_arrows}{A logical, if TRUE, arrows are shown in the biplot.
Default is FALSE.}

\item{...}{Additional graphical parameters.}
}
\value{
A ggplot2 plot object.
}
\description{
Create various plots from a fitted RGCCA object.
}
\details{
\itemize{
\item "samples": scatter plot of the block components. The blocks used
are defined by the block argument, and the components by the comp argument
(Y[[block[1]]][, comp[1]], Y[[block[2]]][,comp[2]]). Points can
be colored according to the response argument.
\item "weights": barplot of the block weight vectors for one
specific block/component. Sorting is applied according to the
display_order argument. The number of displayed weights can be set with
n_marks.
\item "loadings": barplot of the block-loading vectors. Sorting is applied
according to the display_order argument. The number of displayed loadings
can be set with n_marks.
\item  "cor_circle" for correlation circle. It represents the correlation
between the block component corresponding to the first element of the block
argument, and the variables of the block corresponding to the blocks
specified by the argument display_blocks.
\item "both": displays both sample plot and correlation circle (implemented
only for one block and at least when two components are extracted
(ncomp >= 2).
\item "biplot": displays on the same plot the scatter plot of the block
components and the variables used to compute these block components.
\item "ave": displays the average variance explained for each block.}
}
\examples{
data(Russett)
status <- colnames(Russett)[9:11][apply(Russett[, 9:11], 1, which.max)]
X_agric <- as.matrix(Russett[, c("gini", "farm", "rent")])
X_ind <- as.matrix(Russett[, c("gnpr", "labo")])
X_polit <- as.matrix(Russett[, c("demostab", "dictator")])
A <- list(X_agric = X_agric, X_ind = X_ind, X_polit = X_polit)
C <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1, 0), 3, 3)
fit_rgcca <- rgcca(
  blocks = A, connection = C,
  tau = rep(1, 3), ncomp = rep(2, 3)
)

###############
# sample plot #
###############
# horizontal axis: First component of the first block
# vertical axis: First component of the second block
plot(fit_rgcca, type = "sample",
     block = 1:2, comp = 1,
     response = status)

######################
# all types of plots #
######################
plot(fit_rgcca, type = "loadings")
plot(fit_rgcca, type = "weight")
plot(fit_rgcca, type = "sample")
plot(fit_rgcca, type = "cor_circle")
plot(fit_rgcca, type = "biplot")
plot(fit_rgcca, type = "ave")

# with superblock
fit_mcoa <- rgcca(blocks = A, method = "mcoa", ncomp = 2)

plot(fit_mcoa, type = "both", response = status)
plot(fit_mcoa, type = "biplot", response = status)
}
