/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.message.Message;
import org.h2.schema.Schema;
import org.h2.schema.Sequence;

public class CreateSequence
extends SchemaCommand {
    private String sequenceName;
    private boolean ifNotExists;
    private Expression start;
    private Expression increment;
    private Expression cacheSize;
    private boolean belongsToTable;

    public CreateSequence(Session session, Schema schema) {
        super(session, schema);
    }

    public void setSequenceName(String string) {
        this.sequenceName = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public int update() throws SQLException {
        this.session.commit(true);
        Database database = this.session.getDatabase();
        if (this.getSchema().findSequence(this.sequenceName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90035, this.sequenceName);
        }
        int n = this.getObjectId(false, true);
        Sequence sequence = new Sequence(this.getSchema(), n, this.sequenceName, this.belongsToTable);
        sequence.setStartValue(this.getLong(this.start, 1L));
        sequence.setIncrement(this.getLong(this.increment, 1L));
        sequence.setCacheSize(this.getLong(this.cacheSize, 32L));
        database.addSchemaObject(this.session, sequence);
        return 0;
    }

    private long getLong(Expression expression, long l) throws SQLException {
        if (expression == null) {
            return l;
        }
        return expression.optimize(this.session).getValue(this.session).getLong();
    }

    public void setStartWith(Expression expression) {
        this.start = expression;
    }

    public void setIncrement(Expression expression) {
        this.increment = expression;
    }

    public void setBelongsToTable(boolean bl) {
        this.belongsToTable = bl;
    }

    public void setCacheSize(Expression expression) {
        this.cacheSize = expression;
    }
}

