baseFlowSeparation.base<-function(Q,BFSMethod,BFSParams,plot=TRUE)
{
   res<-NULL
   nathan<-function(Q,alpha,plot)
   {
      B<-R<-Q
      B[]<-R[]<-NA
      R[1]<-0
      B[1]<-Q[1]
      for(t in 2:length(Q))
      {
         R[t]<-alpha*R[t-1]+(1+alpha)*(Q[t]+Q[t-1])/2
         if(R[t]<0){R[t]<-0}
         if(R[t]>Q[t]){R[t]<-Q[t]}
         B[t]<-Q[t]-R[t]
      }
      res<-data.frame(Q=Q,B=B,R=R)
      if(plot)
      {
         plot(Q,ylim=c(min(res),max(res)),typ='o')
         lines(B,col=2)
      }
      return(res)
   }

   chapman<-function(Q,alpha,plot)
   {
      B<-R<-Q
      B[]<-R[]<-NA
      R[1]<-0
      B[1]<-Q[1]
      for(t in 2:length(Q))
      {
         R[t]<-((3*alpha-1)/(3-alpha))*Q[t-1]+2/(3-alpha)*(Q[t]-Q[t-1])
         if(R[t]<0){R[t]<-0}
         if(R[t]>Q[t]){R[t]<-Q[t]}
         B[t]<-Q[t]-R[t]
      }
      res<-data.frame(Q=Q,B=B,R=R)
      if(plot)
      {
         plot(Q,ylim=c(min(res),max(res)),typ='o')
         lines(B,col=2)
      }
      return(res)
   }

   eckhardt<-function(Q,alpha,BFI,plot)
   {
      B<-R<-Q
      B[]<-R[]<-NA
      R[1]<-0
      B[1]<-Q[1]
      for(t in 2:length(Q))
      {
         B[t]<-((1-BFI)*alpha*B[t-1]+(1-alpha)*BFI*Q[t])/(1-alpha*BFI)
         if(B[t]>Q[t]){B[t]<-Q[t]}
         R[t]<-Q[t]-B[t]
      }
      res<-data.frame(Q=Q,B=B,R=R)
      if(plot)
      {
         plot(Q,ylim=c(min(res),max(res)),typ='o')
         lines(B,col=2)
      }
      return(res)
   }

   recession<-function(Q,k,timeInterval,plot)
   {
      y<-Q[1:which(Q==max(Q))]
      x<-1:length(y)
      m<-lm(y~x)$coefficients
      start<-floor(abs(m[1]/m[2]))+1
      res<-matrix(NA,length(Q),4)
      res[,1]<-(1:length(Q))*timeInterval/(3600*24)
      res[,2]<-Q
      res[1:start,3]<-Q[1:start]
      res[(start+1):nrow(res),3]<-Q[start]*(k^res[(start+1):nrow(res),1])
      end<-which(res[,3]>res[,2])[1]
      if(is.na(end)){end<-length(Q)}
      res[end:nrow(res),3]<-res[end:nrow(res),2]
      res[,4]<-res[,2]-res[,3]
      res<-res[,-1]
      colnames(res)<-c('Q','B','R')
      if(plot)
      {
         plot(res[,1],ylim=c(min(res),max(res)),typ='o',ylab='Q')
         lines(res[,2],col=2)
      }
      return(res)
   }

   alpha<-BFSParams$alpha
   BFI<-BFSParams$BFI
   timeInterval<-BFSParams$timeInterval
   k<-BFSParams$k

   if(BFSMethod=='nathan')
   {
      NATHAN<-nathan(Q,alpha,plot)
      return(NATHAN)
   }
   if(BFSMethod=='chapman')
   {
      CHAPMAN<-chapman(Q,alpha,plot)
      return(CHAPMAN)
   }
   if(BFSMethod=='eckhardt')
   {
      ECKHARDT<-eckhardt(Q,alpha,BFI,plot)
      return(ECKHARDT)
   }
   if(BFSMethod=='recession')
   {
      RECESSION<-recession(Q,k,timeInterval,plot)
      return(RECESSION)
   }
   if(BFSMethod=='none')
   {
      res<-as.data.frame(matrix(0,length(Q),3))
      colnames(res)<-c('Q','B','R')
      res[,1]<-Q
      res[,3]<-Q
      if(plot)
      {
         plot(Q,ylim=c(min(res),max(res)),typ='o')
         lines(res[,2],col=2)
      }
      return(res)
   }
}