\name{reservoirRouting.base}
\alias{reservoirRouting.base}
\title{
base function for class of \code{reservoirRouting}
}
\description{
function for routing flood through a reservoir using classical Muskingum technique
}
\usage{
\method{reservoirRouting}{base}(inflow, ratingCurve, dischargeCurve,
                 initialStorage, capacity, 
                 simulation)
}
\arguments{
  \item{inflow}{
a vector of runoff time series (cms) representing a runoff event generated by excess rainfall computed by \code{loss} methods or an object inherited from any of the following classes :{\code{transform} ; \code{reachRouting} ; \code{reservoirRouting}}.
}
  \item{ratingCurve}{
a data frame: a data frame at which its first collumn includes height (masl) and second collums presents volume corresponding to the height at first collumn (MCM)
}
  \item{dischargeCurve}{
a data frame: a data frame at which its first collumn includes height (masl) and second collums presents discharge rate corresponding to the height at first collumn (cms)
}
  \item{initialStorage}{
the initial storage of reservoir at the first time step of simulation (MCM)
}
  \item{capacity}{
the maximum volume of reservoir capacity (MCM)
}
  \item{simulation}{
a vectors: number of simulation time steps and the simulation period (seconds)
}
}
\value{
a data.frame:  including inflow time series and routing resaults
}
\references{
Chow, V. T., Maidment, D. R., & Mays, L. W. (1988). Applied hydrology.
}
\seealso{ \code{\link[RHMS]{reservoirRouting}} }
\author{
Rezgar Arabzadeh
}
\keyword{ list }
