% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPowerBand.R
\name{PlotPowerBand}
\alias{PlotPowerBand}
\title{Plots power determined by CalculatePowerBand function}
\usage{
PlotPowerBand(HRVData, indexFreqAnalysis = length(HRVData$FreqAnalysis),
  normalized = FALSE, hr = FALSE, ymax = NULL, ymaxratio = NULL,
  ymaxnorm = 1, Tags = NULL, Indexes = NULL, Tag = NULL,
  verbose = NULL)
}
\arguments{
\item{HRVData}{Data structure that stores the beats register and 
information related to it}

\item{indexFreqAnalysis}{Numeric parameter used to reference a particular
frequency analysis}

\item{normalized}{Plots normalized powers if TRUE}

\item{hr}{Plots heart rate signal if TRUE}

\item{ymax}{Maximum value for y axis (unnormalized plots)}

\item{ymaxratio}{Maximum value for y axis in LF/HF band (normalized and 
unnormalized plots)}

\item{ymaxnorm}{Maximum value for y axis (normalized plots)}

\item{Tags}{List of tags to specify which episodes, as apnoea or oxygen 
desaturation, are included in the plot. Tags = "all" plots all episodes present
in the data.}

\item{Indexes}{List of indexes to specify which episodes (see ListEpisodes),
are included in the plot. Indexes = "all" plots all episodes present
in the data.}

\item{Tag}{Deprecated argument, use Tags instead}

\item{verbose}{Deprecated argument maintained for compatibility, use 
setVerbose() instead}
}
\description{
Plots the power of the heart rate signal at different bands 
of physiological interest.
}
\details{
PlotPowerBand
}
\note{
See \code{\link{PlotSinglePowerBand}} for  a more flexible 
function for plotting power bands.
}
\examples{
\dontrun{
# Reading a wfdb register and storing into a data structure:
md = CreateHRVData(Verbose = TRUE)
md = LoadBeatWFDB(md, RecordName = "register_name", 
                  RecordPath = "register_path")

# Calculating heart rate signal:md = BuildNIHR(md)

# Filtering heart rate signal:
md = FilterNIHR(md)
# Interpolating heart rate signal:
md = InterpolateNIHR(md)
# Calculating spectrogram and power per band:
md = CreateFreqAnalysis(md)
md = CalculatePowerBand(md, indexFreqAnalysis = 1, size = 120, 
                        shift = 10, sizesp = 1024)
# Plotting Power per Band
PlotPowerBand(md, hr = TRUE, ymax = 700000, ymaxratio = 4)
}
}
\author{
M. Lado, A. Mendez, D. Olivieri, L. Rodriguez, X. Vila
}
\references{
L. Rodriguez-Linares, L., A.J. Mendez, M.J. Lado, D.N. Olivieri,
X.A. Vila, and I. Gomez-Conde, "An open source tool for heart rate 
variability spectral analysis", Computer Methods and Programs in 
Biomedicine 103(1):39-50, july 2011.
}
\seealso{
\code{\link{CalculatePowerBand}} for power calculation
and \code{\link{PlotSinglePowerBand}}
}
\keyword{hplot}

