% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_functions.R
\name{count_functions}
\alias{count_functions}
\alias{count_messages}
\alias{count_orders}
\alias{count_trades}
\alias{count_modifications}
\alias{count_system_events}
\alias{count_stock_directory}
\alias{count_trading_status}
\alias{count_reg_sho}
\alias{count_market_participant_states}
\alias{count_mwcb}
\alias{count_ipo}
\alias{count_luld}
\alias{count_noii}
\alias{count_rpii}
\title{Counts the messages of an ITCH-file}
\usage{
count_messages(
  file,
  add_meta_data = FALSE,
  buffer_size = -1,
  quiet = FALSE,
  force_gunzip = FALSE,
  force_cleanup = TRUE
)

count_orders(x)

count_trades(x)

count_modifications(x)

count_system_events(x)

count_stock_directory(x)

count_trading_status(x)

count_reg_sho(x)

count_market_participant_states(x)

count_mwcb(x)

count_ipo(x)

count_luld(x)

count_noii(x)

count_rpii(x)
}
\arguments{
\item{file}{the path to the input file, either a gz-file or a plain-text file}

\item{add_meta_data}{if the meta-data of the messages should be added, defaults to FALSE}

\item{buffer_size}{the size of the buffer in bytes, defaults to 1e8 (100 MB), if you have a large amount of RAM, 1e9 (1GB) might be faster}

\item{quiet}{if TRUE, the status messages are supressed, defaults to FALSE}

\item{force_gunzip}{only applies if file is a gz-file and a file with the same (gunzipped) name already exists.
if set to TRUE, the existing file is overwritten. Default value is FALSE}

\item{force_cleanup}{only applies if file is a gz-file. If force_cleanup=TRUE, the gunzipped raw file will be deleted afterwards.}

\item{x}{a file or a data.table containing the message types and the counts,
as outputted by \code{count_messages}}
}
\value{
a data.table containing the message-type and their counts for \code{count_messages}
or an integer value for the other functions.
}
\description{
Counts the messages of an ITCH-file
}
\details{
\itemize{
\item \code{count_orders}: Counts order messages. Message type \code{A} and \code{F}
}

\itemize{
\item \code{count_trades}: Counts trade messages. Message type \code{P}, \code{Q} and \code{B}
}

\itemize{
\item \code{count_modifications}: Counts order modification messages. Message
type \code{E}, \code{C}, \code{X}, \code{D}, and \code{U}
}

\itemize{
\item \code{count_system_events}: Counts system event messages. Message type \code{S}
}

\itemize{
\item \code{count_stock_directory}: Counts stock trading messages. Message
type \code{R}
}

\itemize{
\item \code{count_trading_status}: Counts trading status messages. Message
type \code{H} and \code{h}
}

\itemize{
\item \code{count_reg_sho}: Counts messages regarding reg SHO. Message type
\code{Y}
}

\itemize{
\item \code{count_market_participant_states}: Counts messages regarding the
status of market participants. Message type \code{L}
}

\itemize{
\item \code{count_mwcb}: Counts messages regarding Market-Wide-Circuit-Breakers
(MWCB). Message type \code{V} and \code{W}
}

\itemize{
\item \code{count_ipo}: Counts messages regarding IPOs. Message type \code{K}
}

\itemize{
\item \code{count_luld}: Counts messages regarding LULDs (limit up-limit down)
auction collars. Message type \code{J}
}

\itemize{
\item \code{count_noii}: Counts Net Order Imbalance Indicatio (NOII) messages.
Message type \code{I}
}

\itemize{
\item \code{count_rpii}: Counts Retail Price Improvement Indicator (RPII)
messages. Message type \code{N}
}
}
\examples{
file <- system.file("extdata", "ex20101224.TEST_ITCH_50", package = "RITCH")
count_messages(file)
count_messages(file, add_meta_data = TRUE, quiet = TRUE)

# file can also be a .gz file
gz_file <- system.file("extdata", "ex20101224.TEST_ITCH_50.gz", package = "RITCH")
count_messages(gz_file, quiet = TRUE)

# count only a specific class
msg_count <- count_messages(file, quiet = TRUE)

# either count based on a given data.table outputted by count_messages
count_orders(msg_count)

# or count orders from a file and not from a msg_count
count_orders(file)

### Specific class count functions are:
count_orders(msg_count)
count_trades(msg_count)
count_modifications(msg_count)
count_system_events(msg_count)
count_stock_directory(msg_count)
count_trading_status(msg_count)
count_reg_sho(msg_count)
count_market_participant_states(msg_count)
count_mwcb(msg_count)
count_ipo(msg_count)
count_luld(msg_count)
count_noii(msg_count)
count_rpii(msg_count)
}
