/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.util.Tools;
import java.util.Properties;

public class ProxySettings
implements PlugIn {
    private static Properties props = System.getProperties();
    private String proxyhost = Prefs.get("proxy.server", "");
    private int proxyport = (int)Prefs.get("proxy.port", 8080.0);
    private String proxyuser = Prefs.get("proxy.user", "");
    private String proxypass = "";
    private boolean authenticate;

    public void run(String string) {
        String string2;
        String string3;
        double d;
        String string4;
        if (IJ.getApplet() != null) {
            return;
        }
        String string5 = System.getProperty("http.proxyHost");
        if (string5 != null) {
            this.proxyhost = string5;
        }
        if ((string4 = System.getProperty("http.proxyPort")) != null && !Double.isNaN(d = Tools.parseDouble(string4))) {
            this.proxyport = (int)d;
        }
        if ((string3 = System.getProperty("http.proxyUser")) != null) {
            this.proxyuser = string3;
        }
        if ((string2 = System.getProperty("http.proxyPassword")) != null) {
            this.proxypass = string2;
        }
        if (!this.showDialog()) {
            return;
        }
        if (!this.proxyhost.equals("")) {
            props.put("proxySet", "true");
        } else {
            props.put("proxySet", "false");
        }
        props.put("http.proxyHost", this.proxyhost);
        props.put("http.proxyPort", "" + this.proxyport);
        props.put("http.proxyUser", this.proxyuser);
        props.put("http.proxyPassword", this.proxypass);
        Prefs.set("proxy.server", this.proxyhost);
        Prefs.set("proxy.port", this.proxyport);
        Prefs.set("proxy.user", this.proxyuser);
        if (IJ.debugMode) {
            IJ.log("proxy set: " + System.getProperty("proxySet"));
            IJ.log("proxy host: " + System.getProperty("http.proxyHost"));
            IJ.log("proxy port: " + System.getProperty("http.proxyPort"));
            IJ.log("proxy username: " + System.getProperty("http.proxyUser"));
            IJ.log("proxy password: " + System.getProperty("http.proxyPassword"));
        }
    }

    boolean showDialog() {
        GenericDialog genericDialog = new GenericDialog("Proxy Settings");
        genericDialog.addStringField("Proxy Server:", this.proxyhost, 15);
        genericDialog.addNumericField("Port:", this.proxyport, 0);
        genericDialog.addCheckbox(" Authenticate", this.authenticate);
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return false;
        }
        this.proxyhost = genericDialog.getNextString();
        this.proxyport = (int)genericDialog.getNextNumber();
        this.authenticate = genericDialog.getNextBoolean();
        if (this.authenticate && !this.proxyhost.equals("")) {
            GenericDialog genericDialog2 = new GenericDialog("Authentication");
            genericDialog2.setInsets(0, 0, 12);
            genericDialog2.addMessage("Enter user name and password for proxy server");
            genericDialog2.addStringField("User:", this.proxyuser, 12);
            genericDialog2.setEchoChar('*');
            genericDialog2.addStringField("Password:", this.proxypass, 12);
            genericDialog2.showDialog();
            if (genericDialog.wasCanceled()) {
                return false;
            }
            this.proxyuser = genericDialog2.getNextString();
            this.proxypass = genericDialog2.getNextString();
        } else {
            this.proxyuser = "";
            this.proxypass = "";
        }
        return true;
    }
}

