/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;

public class WandToolOptions
implements PlugIn {
    private static final String[] modes = new String[]{"Legacy", "4-connected", "8-connected"};
    private static String mode = modes[0];
    private static double tolerance;

    public void run(String string) {
        ImagePlus imagePlus = WindowManager.getCurrentImage();
        boolean bl = imagePlus != null && imagePlus.getBitDepth() != 24 && WindowManager.getFrame("Threshold") == null;
        GenericDialog genericDialog = new GenericDialog("Wand Tool");
        genericDialog.addChoice("Mode: ", modes, mode);
        genericDialog.addNumericField("Tolerance: ", tolerance, 1);
        if (bl) {
            genericDialog.addCheckbox("Enable Thresholding", false);
        }
        genericDialog.showDialog();
        if (genericDialog.wasCanceled()) {
            return;
        }
        mode = genericDialog.getNextChoice();
        tolerance = genericDialog.getNextNumber();
        if (bl && genericDialog.getNextBoolean()) {
            imagePlus.killRoi();
            IJ.run("Threshold...");
        }
    }

    public static String getMode() {
        return mode;
    }

    public static double getTolerance() {
        return tolerance;
    }
}

