/*
 * Decompiled with CFR 0.152.
 */
package ec.benchmarking.ssf.nonlinear;

import ec.benchmarking.BaseDisaggregation;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockStorage;
import ec.tstoolkit.ssf.ISsf;
import ec.tstoolkit.ssf.extended.INonLinearSsf;

public abstract class AbstractLinearizedDisaggregationAlgorithm<S extends INonLinearSsf, T extends ISsf>
extends BaseDisaggregation
implements Cloneable {
    protected DataBlockStorage m_states;
    protected T m_lssf;
    protected double[] m_y;
    protected double[] m_yc;
    private S m_nlssf;
    private double m_eps = 1.0E-6;
    private boolean m_converged;
    private int m_niter;
    private int m_maxiter = 100;

    protected AbstractLinearizedDisaggregationAlgorithm(DataBlock y, int conv, S nlssf) {
        super(conv);
        this.m_nlssf = nlssf;
        this.m_y = new double[y.getLength()];
        y.copyTo(this.m_y, 0);
    }

    protected boolean calc() {
        this.clear();
        if (!this.calcInitialApproximation()) {
            return false;
        }
        this.m_niter = 0;
        do {
            DataBlockStorage next;
            if ((next = this.iterate()) == null) {
                return false;
            }
            if (this.mustStop(next)) break;
            this.m_states = next;
            if (this.calcNextApproximation()) continue;
            return false;
        } while (++this.m_niter < this.m_maxiter);
        this.m_converged = this.m_niter != this.m_maxiter;
        return true;
    }

    protected abstract boolean calcInitialApproximation();

    protected abstract boolean calcNextApproximation();

    protected void clear() {
        this.m_states = null;
        this.m_yc = null;
        this.m_niter = 0;
        this.m_lssf = null;
    }

    public T getLinearizedModel() {
        if (this.m_lssf == null && !this.calc()) {
            return null;
        }
        return this.m_lssf;
    }

    public int getMaxIter() {
        return this.m_maxiter;
    }

    public DataBlock getModifiedObservations() {
        return new DataBlock(this.m_yc);
    }

    public int getNIter() {
        return this.m_niter;
    }

    public S getNonLinearSsf() {
        return this.m_nlssf;
    }

    public DataBlock getObservations() {
        return new DataBlock(this.m_y);
    }

    public double getPrecision() {
        return this.m_eps;
    }

    public DataBlockStorage getStates() {
        if (this.m_states == null && !this.calc()) {
            return null;
        }
        return this.m_states;
    }

    public boolean hasConverged() {
        return this.m_converged;
    }

    protected abstract DataBlockStorage iterate();

    protected boolean mustStop(DataBlockStorage next) {
        DataBlock p1;
        if (this.m_states == null) {
            return false;
        }
        DataBlock p0 = this.m_states.storage(0, this.m_y.length);
        double delta = p0.distance(p1 = next.storage(0, this.m_y.length)) / p0.nrm2();
        return delta < this.m_eps;
    }

    public void setMaxIter(int value) {
        this.m_maxiter = value;
    }

    public void setNIter(int value) {
        this.m_niter = value;
    }

    public void setPrecision(double value) {
        this.m_eps = value;
        this.clear();
    }
}

