/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.arima.AICcComparator;
import ec.tstoolkit.modelling.arima.IModelComparator;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.ModelEstimation;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.PreprocessingModelBuilder;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.RegArimaEstimator;
import ec.tstoolkit.modelling.arima.x13.X13Preprocessor;
import ec.tstoolkit.sarima.SarimaModel;

public class CalendarEffectsDetection
implements IPreprocessingModule {
    private IModelComparator comparer_;
    private ModelEstimation td_;
    private ModelEstimation ntd_;
    private double eps_ = 1.0E-5;

    public double getEpsilon() {
        return this.eps_;
    }

    public void setEpsilon(double val) {
        this.eps_ = val;
    }

    private void clear() {
        this.td_ = null;
        this.ntd_ = null;
    }

    private void addInfo(ModelDescription desc, InformationSet information) {
    }

    public CalendarEffectsDetection() {
        this.comparer_ = new AICcComparator();
    }

    public CalendarEffectsDetection(IModelComparator cmp) {
        this.comparer_ = cmp;
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        ModelDescription ntddesc;
        IParametricMapping<SarimaModel> mapping = X13Preprocessor.createDefaultMapping(context.description);
        RegArimaEstimator monitor = new RegArimaEstimator(mapping);
        monitor.setPrecision(this.eps_);
        this.clear();
        ModelDescription tddesc = context.description.clone();
        if (!PreprocessingModelBuilder.updateCalendar(tddesc, true)) {
            this.td_ = context.estimation;
        }
        if (!PreprocessingModelBuilder.updateCalendar(ntddesc = context.description.clone(), false)) {
            this.ntd_ = context.estimation;
        }
        int nhp = mapping.getDim();
        if (this.td_ == null) {
            try {
                this.td_ = new ModelEstimation(tddesc.buildRegArima(), tddesc.getLikelihoodCorrection());
                this.td_.compute(monitor, nhp);
            }
            catch (Exception err) {
                this.td_ = null;
            }
        }
        if (this.ntd_ == null) {
            try {
                this.ntd_ = new ModelEstimation(ntddesc.buildRegArima(), ntddesc.getLikelihoodCorrection());
                this.ntd_.compute(monitor, nhp);
            }
            catch (Exception err) {
                this.ntd_ = null;
            }
        }
        boolean changed = false;
        if (this.comparer_.compare(this.ntd_, this.td_) == 0) {
            if (context.estimation != this.td_) {
                changed = true;
            }
            context.description = tddesc;
            context.estimation = this.td_;
        } else {
            if (context.estimation != this.ntd_) {
                changed = true;
            }
            context.description = ntddesc;
            context.estimation = this.ntd_;
        }
        this.addInfo(context.description, context.information);
        return changed ? ProcessingResult.Changed : ProcessingResult.Unchanged;
    }
}

