/*
 * Decompiled with CFR 0.152.
 */
package demetra.datatypes.sa;

import demetra.datatypes.Ts;
import demetra.datatypes.sa.EstimationPolicyType;
import demetra.datatypes.sa.SaManager;
import ec.satoolkit.ISaSpecification;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.utilities.NameManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class SaItemType {
    public static final String DOMAIN_SPEC = "domainspec";
    public static final String ESTIMATION_SPEC = "estimationspec";
    public static final String POINT_SPEC = "pointspec";
    public static final String TS = "ts";
    public static final String QUALITY = "quality";
    public static final String PRIORITY = "priority";
    public static final String POLICY = "policy";
    public static final String METADATA = "metadata";
    public static final String NAME = "name";
    public static final String COMMENT = "comment";
    public static final String DIAGNOSTICS = "diagnostics";
    private static final String[] EMPTY = new String[0];
    private static final String NONAME = "";
    @NonNull
    private final Ts ts;
    private final ISaSpecification pointSpec;
    private final ISaSpecification estimationSpec;
    @NonNull
    private final ISaSpecification domainSpec;
    @NonNull
    private final EstimationPolicyType estimationPolicy;
    @NonNull
    private final Status status;
    private final int priority;
    @NonNull
    private final ProcQuality quality;
    @NonNull
    private final String[] warnings;
    @NonNull
    private final String name;
    private final Map<String, String> metaData;

    static SaItemType read(InformationSet info, NameManager<ISaSpecification> defaults, HashMap<String, String> equivalence) {
        InformationSet md;
        String e;
        String q;
        Integer p;
        InformationSet espec;
        Builder builder = SaItemType.builder();
        Ts s = (Ts)info.get(TS, Ts.class);
        if (s == null) {
            return null;
        }
        builder.ts(s);
        String dname = (String)info.get(DOMAIN_SPEC, String.class);
        if (dname == null) {
            return null;
        }
        ISaSpecification dspec = (ISaSpecification)defaults.get(dname);
        if (dspec == null) {
            String ename = equivalence.get(dname);
            if (ename != null) {
                dspec = (ISaSpecification)defaults.get(ename);
            }
            if (dspec == null) {
                return null;
            }
        }
        builder.domainSpec(dspec);
        InformationSet pspec = info.getSubSet(POINT_SPEC);
        if (pspec != null) {
            builder.pointSpec(SaManager.createSpecification(pspec));
        }
        if ((espec = info.getSubSet(ESTIMATION_SPEC)) != null) {
            builder.estimationSpec(SaManager.createSpecification(espec));
        }
        if ((p = (Integer)info.get(PRIORITY, Integer.class)) != null) {
            builder.priority(p);
        }
        if ((q = (String)info.get(QUALITY, String.class)) != null) {
            builder.quality(ProcQuality.valueOf((String)q));
        }
        if ((e = (String)info.get(POLICY, String.class)) != null) {
            builder.estimationPolicy(EstimationPolicyType.valueOf(e));
        }
        if ((md = info.getSubSet(METADATA)) != null) {
            List sel = info.deepSelect(String.class);
            for (Information sinfo : sel) {
                builder.meta(sinfo.name, (String)sinfo.value);
            }
            builder.name((String)info.get(NAME, String.class));
        }
        return builder.build();
    }

    boolean write(InformationSet info, NameManager<ISaSpecification> defaults, boolean verbose) {
        if (!this.name.isEmpty()) {
            info.set(NAME, (Object)this.name);
        }
        info.set(TS, (Object)this.ts);
        String dname = defaults.get((Object)this.domainSpec);
        if (dname == null) {
            dname = defaults.nextName();
            defaults.set(dname, (Object)this.domainSpec);
        }
        info.set(DOMAIN_SPEC, (Object)dname);
        if (this.pointSpec != null) {
            info.set(POINT_SPEC, (Object)this.pointSpec.write(verbose));
        }
        if (this.estimationSpec != null) {
            info.set(ESTIMATION_SPEC, (Object)this.estimationSpec.write(verbose));
        }
        if (this.priority >= 0 || verbose) {
            info.set(PRIORITY, (Object)this.priority);
        }
        if (this.quality != ProcQuality.Undefined || verbose) {
            info.set(QUALITY, (Object)this.quality.name());
        }
        if (this.estimationPolicy != EstimationPolicyType.None) {
            info.set(POLICY, (Object)this.estimationPolicy.name());
        }
        if (!this.metaData.isEmpty()) {
            InformationSet minfo = info.subSet(METADATA);
            for (Map.Entry<String, String> entry : this.metaData.entrySet()) {
                if (entry.getValue().isEmpty()) continue;
                info.set(entry.getKey(), (Object)entry.getValue());
            }
        }
        return true;
    }

    private static EstimationPolicyType $default$estimationPolicy() {
        return EstimationPolicyType.None;
    }

    private static Status $default$status() {
        return Status.Unprocessed;
    }

    private static int $default$priority() {
        return -1;
    }

    private static ProcQuality $default$quality() {
        return ProcQuality.Undefined;
    }

    private static String[] $default$warnings() {
        return EMPTY;
    }

    private static String $default$name() {
        return NONAME;
    }

    SaItemType(@NonNull Ts ts, ISaSpecification pointSpec, ISaSpecification estimationSpec, @NonNull ISaSpecification domainSpec, @NonNull EstimationPolicyType estimationPolicy, @NonNull Status status, int priority, @NonNull ProcQuality quality, @NonNull String[] warnings, @NonNull String name, Map<String, String> metaData) {
        if (ts == null) {
            throw new NullPointerException("ts is marked @NonNull but is null");
        }
        if (domainSpec == null) {
            throw new NullPointerException("domainSpec is marked @NonNull but is null");
        }
        if (estimationPolicy == null) {
            throw new NullPointerException("estimationPolicy is marked @NonNull but is null");
        }
        if (status == null) {
            throw new NullPointerException("status is marked @NonNull but is null");
        }
        if (quality == null) {
            throw new NullPointerException("quality is marked @NonNull but is null");
        }
        if (warnings == null) {
            throw new NullPointerException("warnings is marked @NonNull but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked @NonNull but is null");
        }
        this.ts = ts;
        this.pointSpec = pointSpec;
        this.estimationSpec = estimationSpec;
        this.domainSpec = domainSpec;
        this.estimationPolicy = estimationPolicy;
        this.status = status;
        this.priority = priority;
        this.quality = quality;
        this.warnings = warnings;
        this.name = name;
        this.metaData = metaData;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        Builder builder = new Builder().ts(this.ts).pointSpec(this.pointSpec).estimationSpec(this.estimationSpec).domainSpec(this.domainSpec).estimationPolicy(this.estimationPolicy).status(this.status).priority(this.priority).quality(this.quality).warnings(this.warnings).name(this.name);
        if (this.metaData != null) {
            builder.metaData(this.metaData);
        }
        return builder;
    }

    @NonNull
    public Ts getTs() {
        return this.ts;
    }

    public ISaSpecification getPointSpec() {
        return this.pointSpec;
    }

    public ISaSpecification getEstimationSpec() {
        return this.estimationSpec;
    }

    @NonNull
    public ISaSpecification getDomainSpec() {
        return this.domainSpec;
    }

    @NonNull
    public EstimationPolicyType getEstimationPolicy() {
        return this.estimationPolicy;
    }

    @NonNull
    public Status getStatus() {
        return this.status;
    }

    public int getPriority() {
        return this.priority;
    }

    @NonNull
    public ProcQuality getQuality() {
        return this.quality;
    }

    @NonNull
    public String[] getWarnings() {
        return this.warnings;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaItemType)) {
            return false;
        }
        SaItemType other = (SaItemType)o;
        Ts this$ts = this.getTs();
        Ts other$ts = other.getTs();
        if (this$ts == null ? other$ts != null : !((Object)this$ts).equals(other$ts)) {
            return false;
        }
        ISaSpecification this$pointSpec = this.getPointSpec();
        ISaSpecification other$pointSpec = other.getPointSpec();
        if (this$pointSpec == null ? other$pointSpec != null : !this$pointSpec.equals(other$pointSpec)) {
            return false;
        }
        ISaSpecification this$estimationSpec = this.getEstimationSpec();
        ISaSpecification other$estimationSpec = other.getEstimationSpec();
        if (this$estimationSpec == null ? other$estimationSpec != null : !this$estimationSpec.equals(other$estimationSpec)) {
            return false;
        }
        ISaSpecification this$domainSpec = this.getDomainSpec();
        ISaSpecification other$domainSpec = other.getDomainSpec();
        if (this$domainSpec == null ? other$domainSpec != null : !this$domainSpec.equals(other$domainSpec)) {
            return false;
        }
        EstimationPolicyType this$estimationPolicy = this.getEstimationPolicy();
        EstimationPolicyType other$estimationPolicy = other.getEstimationPolicy();
        if (this$estimationPolicy == null ? other$estimationPolicy != null : !((Object)((Object)this$estimationPolicy)).equals((Object)other$estimationPolicy)) {
            return false;
        }
        Status this$status = this.getStatus();
        Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        ProcQuality this$quality = this.getQuality();
        ProcQuality other$quality = other.getQuality();
        if (this$quality == null ? other$quality != null : !this$quality.equals(other$quality)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getWarnings(), other.getWarnings())) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$metaData = this.getMetaData();
        Map<String, String> other$metaData = other.getMetaData();
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Ts $ts = this.getTs();
        result = result * 59 + ($ts == null ? 43 : ((Object)$ts).hashCode());
        ISaSpecification $pointSpec = this.getPointSpec();
        result = result * 59 + ($pointSpec == null ? 43 : $pointSpec.hashCode());
        ISaSpecification $estimationSpec = this.getEstimationSpec();
        result = result * 59 + ($estimationSpec == null ? 43 : $estimationSpec.hashCode());
        ISaSpecification $domainSpec = this.getDomainSpec();
        result = result * 59 + ($domainSpec == null ? 43 : $domainSpec.hashCode());
        EstimationPolicyType $estimationPolicy = this.getEstimationPolicy();
        result = result * 59 + ($estimationPolicy == null ? 43 : ((Object)((Object)$estimationPolicy)).hashCode());
        Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        result = result * 59 + this.getPriority();
        ProcQuality $quality = this.getQuality();
        result = result * 59 + ($quality == null ? 43 : $quality.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getWarnings());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $metaData = this.getMetaData();
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    public String toString() {
        return "SaItemType(ts=" + this.getTs() + ", pointSpec=" + this.getPointSpec() + ", estimationSpec=" + this.getEstimationSpec() + ", domainSpec=" + this.getDomainSpec() + ", estimationPolicy=" + (Object)((Object)this.getEstimationPolicy()) + ", status=" + (Object)((Object)this.getStatus()) + ", priority=" + this.getPriority() + ", quality=" + this.getQuality() + ", warnings=" + Arrays.deepToString(this.getWarnings()) + ", name=" + this.getName() + ", metaData=" + this.getMetaData() + ")";
    }

    public static class Builder {
        private Ts ts;
        private ISaSpecification pointSpec;
        private ISaSpecification estimationSpec;
        private ISaSpecification domainSpec;
        private boolean estimationPolicy$set;
        private EstimationPolicyType estimationPolicy;
        private boolean status$set;
        private Status status;
        private boolean priority$set;
        private int priority;
        private boolean quality$set;
        private ProcQuality quality;
        private boolean warnings$set;
        private String[] warnings;
        private boolean name$set;
        private String name;
        private ArrayList<String> metaData$key;
        private ArrayList<String> metaData$value;

        Builder() {
        }

        public Builder ts(@NonNull Ts ts) {
            if (ts == null) {
                throw new NullPointerException("ts is marked @NonNull but is null");
            }
            this.ts = ts;
            return this;
        }

        public Builder pointSpec(ISaSpecification pointSpec) {
            this.pointSpec = pointSpec;
            return this;
        }

        public Builder estimationSpec(ISaSpecification estimationSpec) {
            this.estimationSpec = estimationSpec;
            return this;
        }

        public Builder domainSpec(@NonNull ISaSpecification domainSpec) {
            if (domainSpec == null) {
                throw new NullPointerException("domainSpec is marked @NonNull but is null");
            }
            this.domainSpec = domainSpec;
            return this;
        }

        public Builder estimationPolicy(@NonNull EstimationPolicyType estimationPolicy) {
            if (estimationPolicy == null) {
                throw new NullPointerException("estimationPolicy is marked @NonNull but is null");
            }
            this.estimationPolicy = estimationPolicy;
            this.estimationPolicy$set = true;
            return this;
        }

        public Builder status(@NonNull Status status) {
            if (status == null) {
                throw new NullPointerException("status is marked @NonNull but is null");
            }
            this.status = status;
            this.status$set = true;
            return this;
        }

        public Builder priority(int priority) {
            this.priority = priority;
            this.priority$set = true;
            return this;
        }

        public Builder quality(@NonNull ProcQuality quality) {
            if (quality == null) {
                throw new NullPointerException("quality is marked @NonNull but is null");
            }
            this.quality = quality;
            this.quality$set = true;
            return this;
        }

        public Builder warnings(@NonNull String[] warnings) {
            if (warnings == null) {
                throw new NullPointerException("warnings is marked @NonNull but is null");
            }
            this.warnings = warnings;
            this.warnings$set = true;
            return this;
        }

        public Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked @NonNull but is null");
            }
            this.name = name;
            this.name$set = true;
            return this;
        }

        public Builder meta(String metaKey, String metaValue) {
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            this.metaData$key.add(metaKey);
            this.metaData$value.add(metaValue);
            return this;
        }

        public Builder metaData(Map<? extends String, ? extends String> metaData) {
            if (this.metaData$key == null) {
                this.metaData$key = new ArrayList();
                this.metaData$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : metaData.entrySet()) {
                this.metaData$key.add($lombokEntry.getKey());
                this.metaData$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public Builder clearMetaData() {
            if (this.metaData$key != null) {
                this.metaData$key.clear();
                this.metaData$value.clear();
            }
            return this;
        }

        public SaItemType build() {
            Map<Object, Object> metaData;
            switch (this.metaData$key == null ? 0 : this.metaData$key.size()) {
                case 0: {
                    metaData = Collections.emptyMap();
                    break;
                }
                case 1: {
                    metaData = Collections.singletonMap(this.metaData$key.get(0), this.metaData$value.get(0));
                    break;
                }
                default: {
                    metaData = new LinkedHashMap(this.metaData$key.size() < 0x40000000 ? 1 + this.metaData$key.size() + (this.metaData$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.metaData$key.size(); ++$i) {
                        metaData.put(this.metaData$key.get($i), this.metaData$value.get($i));
                    }
                    metaData = Collections.unmodifiableMap(metaData);
                }
            }
            EstimationPolicyType estimationPolicy = this.estimationPolicy;
            if (!this.estimationPolicy$set) {
                estimationPolicy = SaItemType.$default$estimationPolicy();
            }
            Status status = this.status;
            if (!this.status$set) {
                status = SaItemType.$default$status();
            }
            int priority = this.priority;
            if (!this.priority$set) {
                priority = SaItemType.$default$priority();
            }
            ProcQuality quality = this.quality;
            if (!this.quality$set) {
                quality = SaItemType.$default$quality();
            }
            String[] warnings = this.warnings;
            if (!this.warnings$set) {
                warnings = SaItemType.$default$warnings();
            }
            String name = this.name;
            if (!this.name$set) {
                name = SaItemType.$default$name();
            }
            return new SaItemType(this.ts, this.pointSpec, this.estimationSpec, this.domainSpec, estimationPolicy, status, priority, quality, warnings, name, metaData);
        }

        public String toString() {
            return "SaItemType.Builder(ts=" + this.ts + ", pointSpec=" + this.pointSpec + ", estimationSpec=" + this.estimationSpec + ", domainSpec=" + this.domainSpec + ", estimationPolicy=" + (Object)((Object)this.estimationPolicy) + ", status=" + (Object)((Object)this.status) + ", priority=" + this.priority + ", quality=" + this.quality + ", warnings=" + Arrays.deepToString(this.warnings) + ", name=" + this.name + ", metaData$key=" + this.metaData$key + ", metaData$value=" + this.metaData$value + ")";
        }
    }

    public static enum Status {
        Unprocessed,
        NoSpec,
        NoData,
        Pending,
        Valid,
        Invalid;


        public boolean isError() {
            return this.isProcessed() && this != Valid;
        }

        public boolean isProcessed() {
            return this != Unprocessed && this != Pending;
        }
    }
}

