/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices.lapack;

import ec.tstoolkit.maths.matrices.lapack.DIAG;
import ec.tstoolkit.maths.matrices.lapack.OP;
import ec.tstoolkit.maths.matrices.lapack.UPLO;
import ec.tstoolkit.maths.matrices.lapack.Xerbla;

@Deprecated
public class Dtrmv {
    private static final double ZERO = 0.0;

    private static void dtrmv_notrans_lower(DIAG diag, int n, double[] a, int ia, int lda, double[] x, int ix, int incx) {
        if (incx == 1) {
            for (int j = n - 1; j >= 0; --j) {
                if (x[ix + j] == 0.0) continue;
                double temp = x[ix + j];
                for (int i = n - 1; i > j; --i) {
                    int n2 = ix + i;
                    x[n2] = x[n2] + temp * a[ia + i + j * lda];
                }
                if (diag == DIAG.Unit) continue;
                int n3 = ix + j;
                x[n3] = x[n3] * a[ia + j + j * lda];
            }
        } else {
            int j = n - 1;
            int iv = ix + (n - 1) * incx;
            while (j >= 0) {
                if (x[iv] != 0.0) {
                    double temp = x[iv];
                    int i = n - 1;
                    int iw = ix + (n - 1) * incx;
                    while (i > j) {
                        int n4 = iw;
                        x[n4] = x[n4] + temp * a[ia + i + j * lda];
                        --i;
                        iw -= incx;
                    }
                    if (diag != DIAG.Unit) {
                        int n5 = iv;
                        x[n5] = x[n5] * a[ia + j + j * lda];
                    }
                }
                --j;
                iv -= incx;
            }
        }
    }

    private static void dtrmv_notrans_upper(DIAG diag, int n, double[] a, int ia, int lda, double[] x, int ix, int incx) {
        if (incx == 1) {
            for (int j = 0; j < n; ++j) {
                if (x[ix + j] == 0.0) continue;
                double temp = x[ix + j];
                for (int i = 0; i < j; ++i) {
                    int n2 = ix + i;
                    x[n2] = x[n2] + temp * a[ia + i + j * lda];
                }
                if (diag == DIAG.Unit) continue;
                int n3 = ix + j;
                x[n3] = x[n3] * a[ia + j + j * lda];
            }
        } else {
            int j = 0;
            int iv = ix;
            while (j < n) {
                if (x[iv] != 0.0) {
                    double temp = x[iv];
                    int i = 0;
                    int iw = ix;
                    while (i < j) {
                        int n4 = iw;
                        x[n4] = x[n4] + temp * a[ia + i + j * lda];
                        ++i;
                        iw += incx;
                    }
                    if (diag != DIAG.Unit) {
                        int n5 = iv;
                        x[n5] = x[n5] * a[ia + j + j * lda];
                    }
                }
                ++j;
                iv += incx;
            }
        }
    }

    private static void dtrmv_trans_lower(DIAG diag, int n, double[] a, int ia, int lda, double[] x, int ix, int incx) {
        if (incx == 1) {
            for (int j = 0; j < n; ++j) {
                double temp = x[ix + j];
                if (diag != DIAG.Unit) {
                    temp *= a[ia + j + j * lda];
                }
                for (int i = j + 1; i < n; ++i) {
                    temp += a[ia + i + j * lda] * x[ix + i];
                }
                x[ix + j] = temp;
            }
        } else {
            int j = 0;
            int iv = ix;
            while (j < n) {
                double temp = x[iv];
                if (diag != DIAG.Unit) {
                    temp *= a[ia + j + j * lda];
                }
                int iw = ix + incx;
                for (int i = j + 1; i < n; ++i) {
                    temp += a[ia + i + j * lda] * x[iw];
                }
                x[iv] = temp;
                ++j;
                iv += incx;
            }
        }
    }

    private static void dtrmv_trans_upper(DIAG diag, int n, double[] a, int ia, int lda, double[] x, int ix, int incx) {
        if (incx == 1) {
            for (int j = n - 1; j >= 0; --j) {
                double temp = x[ix + j];
                if (diag != DIAG.Unit) {
                    temp *= a[ia + j + j * lda];
                }
                for (int i = j - 1; i >= 0; --i) {
                    temp += a[ia + i + j * lda] * x[ix + i];
                }
                x[ix + j] = temp;
            }
        } else {
            int j = n - 1;
            int iv = ix + (n - 1) * incx;
            while (j >= 0) {
                double temp = x[iv];
                if (diag != DIAG.Unit) {
                    temp *= a[ia + j + j * lda];
                }
                int i = j - 1;
                int iw = ix - incx;
                while (i >= 0) {
                    temp += a[ia + i + j * lda] * x[iw];
                    --i;
                    iw -= incx;
                }
                x[iv] = temp;
                --j;
                iv -= incx;
            }
        }
    }

    public static void fn(UPLO uplo, OP trans, DIAG diag, int n, double[] a, int ia, int lda, double[] x, int ix, int incx) throws Xerbla {
        int info = 0;
        if (n < 0) {
            info = 4;
        } else if (lda < Math.max(1, n)) {
            info = 6;
        } else if (incx == 0) {
            info = 8;
        }
        if (info != 0) {
            throw new Xerbla("Dtrmv", info);
        }
        if (n == 0) {
            return;
        }
        if (trans == OP.None) {
            if (uplo == UPLO.Upper) {
                Dtrmv.dtrmv_notrans_upper(diag, n, a, ia, lda, x, ix, incx);
            } else {
                Dtrmv.dtrmv_notrans_lower(diag, n, a, ia, lda, x, ix, incx);
            }
        } else if (uplo == UPLO.Upper) {
            Dtrmv.dtrmv_trans_upper(diag, n, a, ia, lda, x, ix, incx);
        } else {
            Dtrmv.dtrmv_trans_lower(diag, n, a, ia, lda, x, ix, incx);
        }
    }
}

