/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.regression;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.regression.AbstractSingleTsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.StringFormatter;
import java.util.Objects;

public class Ramp
extends AbstractSingleTsVariable
implements IUserTsVariable,
Cloneable {
    private Day start;
    private Day end;
    public static final String PREFIX = "rp";

    public Ramp() {
        this.start = Day.toDay().minus(1);
        this.end = Day.toDay();
    }

    public Ramp(Day start, Day end) {
        if (end.isNotAfter(start)) {
            throw new TsException("Invalid Ramp");
        }
        this.start = start;
        this.end = end;
    }

    public Ramp clone() {
        try {
            return (Ramp)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public Day getStart() {
        return this.start;
    }

    public void setStart(Day start) {
        if (start.isAfter(this.end)) {
            return;
        }
        this.start = start;
    }

    public Day getEnd() {
        return this.end;
    }

    public void setEnd(Day end) {
        if (end.isBefore(this.start)) {
            return;
        }
        this.end = end;
    }

    @Override
    public void data(TsPeriod pstart, DataBlock data) {
        int t0 = new TsPeriod(pstart.getFrequency(), this.start.minus(1)).minus(pstart);
        int t1 = new TsPeriod(pstart.getFrequency(), this.end.plus(1)).minus(pstart);
        int len = data.getLength();
        if (t1 == t0) {
            data.set(0.0);
            return;
        }
        if (t0 >= 0) {
            if (t0 >= len) {
                data.set(-1.0);
                return;
            }
            data.range(0, t0 + 1).set(-1.0);
        }
        if (t1 < len) {
            if (t1 <= 0) {
                data.set(0.0);
                return;
            }
            data.range(t1, len).set(0.0);
        }
        int k0 = Math.max(t0 + 1, 0);
        int k1 = Math.min(t1, len);
        double denom = t1 - t0;
        for (int k = k0; k < k1; ++k) {
            data.set(k, (double)(k - t0) / denom - 1.0);
        }
    }

    @Override
    public String getDescription(TsFrequency context) {
        StringBuilder builder = new StringBuilder();
        if (context != TsFrequency.Undefined) {
            builder.append("rp:").append(new TsPeriod(context, this.start.minus(1))).append(" - ").append(new TsPeriod(context, this.end.plus(1)));
        } else {
            builder.append("rp:").append(this.start).append(" - ").append(this.end);
        }
        return builder.toString();
    }

    @Override
    public boolean isSignificant(TsDomain domain) {
        Day dend = domain.getLast().firstday();
        Day dstart = domain.getStart().lastday();
        return this.end.isAfter(dstart) && this.start.isBefore(dend);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof Ramp && this.equals((Ramp)obj);
    }

    private boolean equals(Ramp other) {
        return other.start.equals((Object)this.start) && other.end.equals((Object)this.end);
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.start);
        hash = 43 * hash + Objects.hashCode(this.end);
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(PREFIX).append('.').append(StringFormatter.convert(this.start)).append('.').append(StringFormatter.convert(this.end));
        return builder.toString();
    }

    public String toString(TsFrequency freq) {
        if (freq == TsFrequency.Undefined) {
            return this.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(PREFIX).append('.').append(StringFormatter.write(new TsPeriod(freq, this.start.minus(1)))).append('.').append(StringFormatter.write(new TsPeriod(freq, this.end.plus(1))));
        return builder.toString();
    }

    @Override
    public String getName() {
        return this.toString().replace('.', '$');
    }

    public static Ramp fromString(String s) {
        String[] ss = InformationSet.split(s);
        if (ss.length != 3) {
            return null;
        }
        if (!ss[0].equals(PREFIX)) {
            return null;
        }
        Day start = StringFormatter.convertDay(ss[1]);
        Day end = StringFormatter.convertDay(ss[2]);
        if (start != null && end != null) {
            return new Ramp(start, end);
        }
        TsPeriod pstart = StringFormatter.readPeriod(ss[1]);
        TsPeriod pend = StringFormatter.readPeriod(ss[2]);
        if (pstart != null && pend != null) {
            return new Ramp(pstart.firstday(), pend.lastday());
        }
        return null;
    }
}

