/*
 * Decompiled with CFR 0.152.
 */
package demetra.workspace.io;

import java.io.Closeable;
import java.io.IOException;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public final class IoUtil {
    public static void closeAll(@Nonnull Closeable first, @Nonnull Closeable second) throws IOException {
        try {
            first.close();
        }
        catch (IOException ex) {
            throw IoUtil.ensureClosed(ex, second);
        }
        second.close();
    }

    public static <T extends Throwable> T ensureClosed(@Nonnull T ex, @Nonnull Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException suppressed) {
            ex.addSuppressed(suppressed);
        }
        return ex;
    }

    @Nonnull
    public static <T> Supplier<Iterable<T>> supplierOfServiceLoader(@Nonnull Class<T> type) {
        return () -> ServiceLoader.load(type);
    }

    private IoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

