/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.x11.DefaultExtremeValuesCorrector;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.timeseries.simplets.PeriodIterator;
import ec.tstoolkit.timeseries.simplets.TsData;

public class PeriodSpecificExtremeValuesCorrector
extends DefaultExtremeValuesCorrector {
    @Override
    protected void calcStdev() {
        Integer i = 0;
        PeriodIterator iteri = new PeriodIterator(this.scur);
        Integer np = this.scur.getFrequency().intValue();
        this.stdev = new double[np.intValue()];
        while (iteri.hasMoreElements()) {
            DataBlock dbi = iteri.nextElement().data;
            this.stdev[i.intValue()] = this.calcStdev(dbi);
            i = i + 1;
        }
    }

    @Override
    protected int outliersDetection() {
        int nval = 0;
        this.sweights = new TsData(this.scur.getDomain());
        PeriodIterator iteri = new PeriodIterator(this.scur);
        PeriodIterator itero = new PeriodIterator(this.sweights);
        this.sweights.set(() -> 1.0);
        double xbar = this.getMean();
        int y = 0;
        while (iteri.hasMoreElements()) {
            double lv = this.stdev[y] * this.lsigma;
            double uv = this.stdev[y] * this.usigma;
            DataBlock dbi = iteri.nextElement().data;
            DataBlock dbo = itero.nextElement().data;
            for (int i = 0; i < dbi.getLength(); ++i) {
                double tt = Math.abs(dbi.get(i) - xbar);
                if (tt > uv) {
                    dbo.set(i, 0.0);
                    ++nval;
                    continue;
                }
                if (!(tt > lv)) continue;
                dbo.set(i, (uv - tt) / (uv - lv));
            }
            ++y;
        }
        return nval;
    }

    @Override
    public double[] getStandardDeviations() {
        return this.stdev;
    }
}

