/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.arima.estimation.ModifiedLjungBoxFilter;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.modelling.arima.IPreprocessingController;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.stats.LjungBoxTest;

public class ModelController
implements IPreprocessingController {
    private double tmu_ = 1.0;
    private double lb_ = 0.95;
    private LjungBoxTest lbtest_;
    private double rvr_;
    private double rtval_;

    public ModelController(double lb, double tmu) {
        this.lb_ = lb;
        this.tmu_ = tmu;
    }

    public ModelController() {
    }

    public LjungBoxTest getLjungBoxTest() {
        return this.lbtest_;
    }

    @Override
    public boolean accept(ModellingContext context) {
        double[] coeff = context.estimation.getLikelihood().getB();
        DataBlock res = context.estimation.getRegArima().getDModel().calcRes(new DataBlock(coeff));
        SarimaModel arma = context.estimation.getRegArima().getArma();
        ModifiedLjungBoxFilter filter = new ModifiedLjungBoxFilter();
        int nres = filter.initialize(arma, res.getLength());
        DataBlock fres = new DataBlock(nres);
        filter.filter(res, fres);
        int nobs = context.estimation.getStatistics().effectiveObservationsCount;
        this.rvr_ = Math.sqrt(fres.ssq() / (double)context.estimation.getLikelihood().getDegreesOfFreedom(false, 0));
        fres = fres.drop(nres - nobs, 0);
        this.calcResStat(fres);
        int sp = context.description.getFrequency();
        if (!this.calcLb(fres, ModelController.calcLbLength(sp, nobs), context.description.getArimaComponent().getFreeParametersCount())) {
            return false;
        }
        return !(1.0 - this.lbtest_.getPValue() > this.lb_);
    }

    private static int calcLbLength(int sp, int nobs) {
        int lbdf;
        if (sp == 12) {
            lbdf = 24;
        } else if (sp == 1) {
            lbdf = 8;
        } else {
            lbdf = 4 * sp;
            if (nobs <= 22 && sp == 4) {
                lbdf = 6;
            }
        }
        if (lbdf >= nobs) {
            lbdf = nobs / 2;
        }
        return lbdf;
    }

    private boolean calcLb(DataBlock res, int nlb, int nhp) {
        try {
            double mu = res.sum() / (double)res.getLength();
            res.sub(mu);
            this.lbtest_ = new LjungBoxTest();
            this.lbtest_.setK(nlb);
            this.lbtest_.setHyperParametersCount(nhp);
            this.lbtest_.test(res);
            return this.lbtest_.isValid();
        }
        catch (RuntimeException err) {
            return false;
        }
    }

    private void calcResStat(DataBlock res) {
        double rm = res.sum();
        double rv = res.ssq();
        int n = res.getLength();
        rv = rv / (double)n - (rm /= (double)n) * rm;
        double rstd = Math.sqrt(rv / (double)n);
        this.rtval_ = rm / rstd;
    }

    public double getRTval() {
        return this.rtval_;
    }

    public double getRvr() {
        return this.rvr_;
    }
}

