/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.TsVariableDescriptor;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.Ramp;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.Comparator;
import ec.tstoolkit.utilities.Jdk6;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RegressionSpec
implements Cloneable,
InformationSetSerializable {
    private CalendarSpec calendar_ = new CalendarSpec();
    private ArrayList<OutlierDefinition> outliers_ = new ArrayList();
    private ArrayList<Ramp> ramps_ = new ArrayList();
    private ArrayList<InterventionVariable> interventions_ = new ArrayList();
    private ArrayList<TsVariableDescriptor> users_ = new ArrayList();
    private Map<String, double[]> fcoeff = new LinkedHashMap<String, double[]>();
    private Map<String, double[]> coeff = new LinkedHashMap<String, double[]>();
    public static final String CALENDAR = "calendar";
    public static final String OUTLIERS = "outliers";
    public static final String USER = "user";
    public static final String USERS = "user*";
    public static final String RAMPS = "ramps";
    public static final String INTERVENTION = "intervention";
    public static final String INTERVENTIONS = "intervention*";
    public static final String COEFF = "coefficients";
    public static final String FCOEFF = "fixedcoefficients";
    private static final String[] DICTIONARY = new String[]{"calendar", "outliers", "user*", "ramps", "intervention*", "coefficients", "fixedcoefficients"};

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, OUTLIERS), String[].class);
        dic.put(InformationSet.item(prefix, RAMPS), String[].class);
        CalendarSpec.fillDictionary(InformationSet.item(prefix, CALENDAR), dic);
        InterventionVariable.fillDictionary(InformationSet.item(prefix, INTERVENTIONS), dic);
        TsVariableDescriptor.fillDictionary(InformationSet.item(prefix, USERS), dic);
    }

    public void reset() {
        this.outliers_.clear();
        this.ramps_.clear();
        this.interventions_.clear();
        this.users_.clear();
        this.fcoeff.clear();
        this.coeff.clear();
    }

    public boolean isUsed() {
        return this.calendar_.isUsed() || !this.outliers_.isEmpty() || !this.ramps_.isEmpty() || !this.interventions_.isEmpty() || !this.users_.isEmpty();
    }

    public CalendarSpec getCalendar() {
        return this.calendar_;
    }

    public void setCalendar(CalendarSpec value) {
        if (value == null) {
            throw new IllegalArgumentException(CALENDAR);
        }
        this.calendar_ = value;
    }

    public OutlierDefinition[] getOutliers() {
        return Jdk6.Collections.toArray(this.outliers_, OutlierDefinition.class);
    }

    public void setOutliers(OutlierDefinition[] value) {
        this.outliers_.clear();
        if (value != null) {
            Collections.addAll(this.outliers_, value);
        }
    }

    public TsVariableDescriptor[] getUserDefinedVariables() {
        return Jdk6.Collections.toArray(this.users_, TsVariableDescriptor.class);
    }

    public void setUserDefinedVariables(TsVariableDescriptor[] value) {
        this.users_.clear();
        if (value != null) {
            Collections.addAll(this.users_, value);
        }
    }

    public InterventionVariable[] getInterventionVariables() {
        return Jdk6.Collections.toArray(this.interventions_, InterventionVariable.class);
    }

    public void setInterventionVariables(InterventionVariable[] value) {
        this.interventions_.clear();
        if (value != null) {
            Collections.addAll(this.interventions_, value);
        }
    }

    public boolean isDefault() {
        return this.calendar_.isDefault() && this.users_.isEmpty() && this.outliers_.isEmpty() && this.interventions_.isEmpty();
    }

    public void add(TsVariableDescriptor svar) {
        this.users_.add(svar);
    }

    public void add(OutlierDefinition outlier) {
        this.outliers_.add(outlier);
    }

    public boolean contains(OutlierDefinition outlier) {
        return this.outliers_.stream().anyMatch(def -> def.equals((Object)outlier));
    }

    public void add(IOutlierVariable outlier) {
        this.outliers_.add(new OutlierDefinition(outlier.getPosition(), outlier.getCode()));
    }

    public void add(InterventionVariable ivar) {
        this.interventions_.add(ivar);
    }

    public void clearUserDefinedVariables() {
        this.users_.clear();
    }

    public int getUserDefinedVariablesCount() {
        return this.users_.size();
    }

    public TsVariableDescriptor getUserDefinedVariable(int idx) {
        return this.users_.get(idx);
    }

    public void clearOutliers() {
        this.outliers_.clear();
    }

    public int getOutliersCount() {
        return this.outliers_.size();
    }

    public OutlierDefinition getOutlier(int idx) {
        return this.outliers_.get(idx);
    }

    public void clearInterventionVariables() {
        this.interventions_.clear();
    }

    public int getInterventionVariablesCount() {
        return this.interventions_.size();
    }

    public InterventionVariable getInterventionVariable(int idx) {
        return this.interventions_.get(idx);
    }

    public String[] getRegressionVariableNames(TsFrequency freq) {
        return this.getRegressionVariableNames(freq, false);
    }

    public String[] getRegressionVariableShortNames(TsFrequency freq) {
        return this.getRegressionVariableNames(freq, true);
    }

    private String[] getRegressionVariableNames(TsFrequency freq, boolean shortname) {
        ArrayList<String> names = new ArrayList<String>();
        if (this.calendar_.isUsed()) {
            if (this.calendar_.getTradingDays().isDefined()) {
                if (this.calendar_.getTradingDays().isStockTradingDays()) {
                    if (shortname) {
                        names.add("td");
                    } else {
                        names.add("td#6");
                    }
                } else {
                    String[] user = this.calendar_.getTradingDays().getUserVariables();
                    if (user != null) {
                        for (String username : user) {
                            if (!username.startsWith("td|")) {
                                username = "td|" + username;
                            }
                            names.add(ITsVariable.validName(username));
                        }
                    } else {
                        if (this.calendar_.getTradingDays().getTradingDaysType() == TradingDaysType.WorkingDays || shortname) {
                            names.add("td");
                        } else {
                            names.add("td#6");
                        }
                        if (this.calendar_.getTradingDays().isLeapYear()) {
                            names.add("lp");
                        }
                    }
                }
            }
            if (this.calendar_.getEaster().isDefined()) {
                names.add("easter");
            }
        }
        this.outliers_.stream().map(def -> {
            StringBuilder builder = new StringBuilder();
            builder.append(def.getCode()).append(" (");
            if (freq == TsFrequency.Undefined) {
                builder.append(def.getPosition());
            } else {
                TsPeriod p = new TsPeriod(freq, def.getPosition());
                builder.append(p);
            }
            return builder.append(')');
        }).forEach(builder -> names.add(builder.toString()));
        this.ramps_.forEach(rp -> names.add(rp.getName()));
        this.interventions_.forEach(iv -> {
            String n = iv.getName();
            if (names.contains(n)) {
                n = n + '*';
            }
            names.add(n);
        });
        this.users_.forEach(uv -> {
            int n = uv.getLastLag() - uv.getFirstLag() + 1;
            if (n == 1 || shortname) {
                names.add(RegressionSpec.validName(uv.getName()));
            } else {
                names.add(RegressionSpec.validName(uv.getName()) + '#' + n);
            }
        });
        String[] all = new String[names.size()];
        return names.toArray(all);
    }

    private static String validName(String name) {
        return name.replace('.', '@');
    }

    public double[] getCoefficients(String name) {
        return this.coeff.get(name);
    }

    public void setCoefficients(String name, double[] c) {
        this.coeff.put(name, c);
    }

    public void clearAllCoefficients() {
        this.coeff.clear();
    }

    public void clearCoefficients(String name) {
        this.coeff.remove(name);
    }

    public double[] getFixedCoefficients(String name) {
        return this.fcoeff.get(name);
    }

    public void setAllFixedCoefficients(Map<String, double[]> coeffs) {
        this.clearAllFixedCoefficients();
        this.fcoeff.putAll(coeffs);
    }

    public Map<String, double[]> getAllFixedCoefficients() {
        this.checkFixedCoefficients();
        return Collections.unmodifiableMap(this.fcoeff);
    }

    public Map<String, double[]> getAllCoefficients() {
        return Collections.unmodifiableMap(this.coeff);
    }

    public void setFixedCoefficients(String name, double[] c) {
        this.fcoeff.put(name, c);
    }

    public void clearAllFixedCoefficients() {
        this.fcoeff.clear();
    }

    public void clearFixedCoefficients(String name) {
        this.fcoeff.remove(name);
    }

    public void clearRamps() {
        this.ramps_.clear();
    }

    public int getRampsCount() {
        return this.ramps_.size();
    }

    public Ramp getRamp(int idx) {
        return this.ramps_.get(idx);
    }

    public void add(Ramp rp) {
        this.ramps_.add(rp);
    }

    public Ramp[] getRamps() {
        return Jdk6.Collections.toArray(this.ramps_, Ramp.class);
    }

    public void setRamps(Ramp[] value) {
        this.ramps_.clear();
        if (value != null) {
            Collections.addAll(this.ramps_, value);
        }
    }

    public RegressionSpec clone() {
        try {
            RegressionSpec spec = (RegressionSpec)super.clone();
            spec.interventions_ = new ArrayList();
            this.interventions_.forEach(ii -> spec.interventions_.add(ii.clone()));
            spec.outliers_ = Jdk6.newArrayList(this.outliers_);
            spec.ramps_ = new ArrayList();
            this.ramps_.forEach(r -> spec.ramps_.add(r.clone()));
            spec.calendar_ = this.calendar_.clone();
            spec.users_ = new ArrayList();
            this.users_.forEach(var -> spec.users_.add(var.clone()));
            spec.fcoeff = new LinkedHashMap<String, double[]>();
            this.fcoeff.forEach((name, c) -> spec.fcoeff.put((String)name, (double[])c));
            spec.coeff = new LinkedHashMap<String, double[]>();
            this.coeff.forEach((name, c) -> spec.coeff.put((String)name, (double[])c));
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof RegressionSpec && this.equals((RegressionSpec)obj);
    }

    private boolean equals(RegressionSpec other) {
        return Comparator.equals(this.interventions_, other.interventions_) && Comparator.equals(this.users_, other.users_) && Comparator.equals(this.ramps_, other.ramps_) && Comparator.equals(this.outliers_, other.outliers_) && Objects.equals(this.calendar_, other.calendar_) && this.compare(this.fcoeff, other.fcoeff);
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.calendar_.hashCode();
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        InformationSet icoeff;
        InformationSet cur;
        int i;
        InformationSet cinfo;
        if (!this.isUsed()) {
            return null;
        }
        InformationSet specInfo = new InformationSet();
        if ((verbose || !this.calendar_.isDefault()) && (cinfo = this.calendar_.write(verbose)) != null) {
            specInfo.add(CALENDAR, cinfo);
        }
        if (!this.outliers_.isEmpty()) {
            String[] outliers = new String[this.outliers_.size()];
            for (i = 0; i < outliers.length; ++i) {
                outliers[i] = this.outliers_.get(i).toString();
            }
            specInfo.add(OUTLIERS, outliers);
        }
        if (!this.ramps_.isEmpty()) {
            String[] ramps = new String[this.ramps_.size()];
            for (i = 0; i < ramps.length; ++i) {
                ramps[i] = this.ramps_.get(i).toString();
            }
            specInfo.add(RAMPS, ramps);
        }
        int idx = 1;
        for (TsVariableDescriptor desc : this.users_) {
            cur = desc.write(verbose);
            if (cur == null) continue;
            specInfo.add(USER + Integer.toString(idx++), cur);
        }
        idx = 1;
        for (InterventionVariable ivar : this.interventions_) {
            cur = ivar.write(verbose);
            if (cur == null) continue;
            specInfo.add(INTERVENTION + Integer.toString(idx++), cur);
        }
        if (!this.fcoeff.isEmpty()) {
            icoeff = specInfo.subSet(FCOEFF);
            this.fcoeff.forEach((s, c) -> icoeff.set((String)s, ((double[])c).length == 1 ? (Object)c[0] : c));
        }
        if (!this.coeff.isEmpty()) {
            icoeff = specInfo.subSet(COEFF);
            this.coeff.forEach((s, c) -> icoeff.set((String)s, ((double[])c).length == 1 ? (Object)c[0] : c));
        }
        return specInfo;
    }

    @Override
    public boolean read(InformationSet info) {
        InformationSet icoeff;
        List<Information<Double>> sall;
        List<Information<double[]>> all;
        String[] ramps;
        boolean tok;
        this.reset();
        InformationSet cinfo = info.getSubSet(CALENDAR);
        if (cinfo != null && !(tok = this.calendar_.read(cinfo))) {
            return false;
        }
        String[] outliers = info.get(OUTLIERS, String[].class);
        if (outliers != null) {
            for (int i = 0; i < outliers.length; ++i) {
                OutlierDefinition o = OutlierDefinition.fromString(outliers[i]);
                if (o == null) {
                    return false;
                }
                this.outliers_.add(o);
            }
        }
        if ((ramps = info.get(RAMPS, String[].class)) != null) {
            for (int i = 0; i < ramps.length; ++i) {
                Ramp r = Ramp.fromString(ramps[i]);
                if (r == null) {
                    return false;
                }
                this.ramps_.add(r);
            }
        }
        List<Information<InformationSet>> usel = info.select(USERS, InformationSet.class);
        usel.forEach(item -> {
            TsVariableDescriptor cur = new TsVariableDescriptor();
            if (cur.read((InformationSet)item.value)) {
                this.users_.add(cur);
            }
        });
        List<Information<InformationSet>> isel = info.select(INTERVENTIONS, InformationSet.class);
        isel.forEach(item -> {
            InterventionVariable cur = new InterventionVariable();
            if (cur.read((InformationSet)item.value)) {
                this.interventions_.add(cur);
            }
        });
        InformationSet ifcoeff = info.getSubSet(FCOEFF);
        if (ifcoeff != null) {
            TradingDaysSpec td = this.calendar_.getTradingDays();
            all = ifcoeff.select(double[].class);
            all.forEach(item -> {
                if (td != null && td.getUserVariables() != null && "td".equals(item.name) && ((double[])item.value).length == td.getUserVariables().length) {
                    for (int j = 0; j < ((double[])item.value).length; ++j) {
                        this.fcoeff.put(ITsVariable.validName("td|" + td.getUserVariables()[j]), new double[]{((double[])item.value)[j]});
                    }
                } else {
                    this.fcoeff.put(item.name, (double[])item.value);
                }
            });
            sall = ifcoeff.select(Double.class);
            sall.forEach(item -> {
                if (td != null && td.getUserVariables() != null && "td".equals(item.name) && 1 == td.getUserVariables().length) {
                    this.fcoeff.put(ITsVariable.validName("td|" + td.getUserVariables()[0]), new double[]{(Double)item.value});
                } else {
                    this.fcoeff.put(item.name, new double[]{(Double)item.value});
                }
            });
        }
        if ((icoeff = info.getSubSet(COEFF)) != null) {
            all = icoeff.select(double[].class);
            all.stream().forEach(reg -> this.coeff.put(reg.name, (double[])reg.value));
            sall = icoeff.select(Double.class);
            sall.stream().forEach(reg -> this.coeff.put(reg.name, new double[]{(Double)reg.value}));
        }
        return true;
    }

    private boolean compare(Map<String, double[]> cl, Map<String, double[]> cr) {
        if (cl.size() != cr.size()) {
            return false;
        }
        Optional<Map.Entry> any = cl.entrySet().stream().filter(entry -> {
            if (!cr.containsKey(entry.getKey())) {
                return true;
            }
            return !Arrays.equals((double[])entry.getValue(), (double[])cr.get(entry.getKey()));
        }).findAny();
        return !any.isPresent();
    }

    public boolean hasFixedCoefficients() {
        return !this.fcoeff.isEmpty();
    }

    public boolean hasFixedCoefficients(String shortname) {
        Optional<String> any = this.fcoeff.keySet().stream().filter(x -> shortname.equals(ITsVariable.shortName(x))).findAny();
        return any.isPresent();
    }

    private void checkFixedCoefficients() {
        Object[] names = this.getRegressionVariableShortNames(TsFrequency.Undefined);
        Arrays.sort(names);
        List<String> toremove = this.fcoeff.keySet().stream().filter(arg_0 -> RegressionSpec.lambda$checkFixedCoefficients$363((String[])names, arg_0)).collect(Collectors.toList());
        int i = 0;
        for (Object name : names) {
            if (!((String)name).startsWith("td|")) continue;
            ++i;
        }
        if (toremove.contains("td") && this.fcoeff.get("td").length != i) {
            toremove.remove("td");
        }
        toremove.forEach(s -> this.fcoeff.remove(s));
    }

    private static /* synthetic */ boolean lambda$checkFixedCoefficients$363(String[] names, String s) {
        return Arrays.binarySearch(names, s) < 0;
    }
}

