/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.matrices.lapack;

import ec.tstoolkit.maths.matrices.lapack.OP;
import ec.tstoolkit.maths.matrices.lapack.UPLO;
import ec.tstoolkit.maths.matrices.lapack.Xerbla;

@Deprecated
public class Dsyrk {
    private static final double ZERO = 0.0;
    private static final double ONE = 1.0;

    private static void fn_zeroalpha(UPLO uplo, int n, double beta, double[] c, int ic, int ldc) {
        if (uplo == UPLO.Upper) {
            if (beta == 0.0) {
                for (int j = 0; j < n; ++j) {
                    for (int i = 0; i <= j; ++i) {
                        c[ic + i + j * ldc] = 0.0;
                    }
                }
            } else {
                for (int j = 0; j < n; ++j) {
                    for (int i = 0; i <= j; ++i) {
                        int n2 = ic + i + j * ldc;
                        c[n2] = c[n2] * beta;
                    }
                }
            }
        } else if (beta == 0.0) {
            for (int j = 0; j < n; ++j) {
                for (int i = j; i < n; ++i) {
                    c[ic + i + j * ldc] = 0.0;
                }
            }
        } else {
            for (int j = 0; j < n; ++j) {
                for (int i = j; i < n; ++i) {
                    int n3 = ic + i + j * ldc;
                    c[n3] = c[n3] * beta;
                }
            }
        }
    }

    public void fn(UPLO uplo, OP trans, int n, int k, double alpha, double[] a, int ia, int lda, double beta, double[] c, int ic, int ldc) throws Xerbla {
        int nrowa = trans == OP.None ? n : k;
        int info = 0;
        if (n < 0) {
            info = 3;
        } else if (k < 0) {
            info = 4;
        } else if (lda < Math.max(1, nrowa)) {
            info = 7;
        } else if (ldc < Math.max(1, n)) {
            info = 10;
        }
        if (info != 0) {
            throw new Xerbla("Dsyrk", info);
        }
        if (n == 0 || (alpha == 0.0 || k == 0) && beta == 1.0) {
            return;
        }
        if (alpha == 0.0) {
            Dsyrk.fn_zeroalpha(uplo, n, beta, c, ic, ldc);
        } else if (trans == OP.None) {
            if (uplo == UPLO.Upper) {
                this.fn_notrans_upper(n, k, alpha, a, ia, lda, beta, c, ic, ldc);
            } else {
                this.fn_notrans_lower(n, k, alpha, a, ia, lda, beta, c, ic, ldc);
            }
        } else if (uplo == UPLO.Upper) {
            this.fn_trans_upper(n, k, alpha, a, ia, lda, beta, c, ic, ldc);
        } else {
            this.fn_trans_lower(n, k, alpha, a, ia, lda, beta, c, ic, ldc);
        }
    }

    private void fn_notrans_lower(int n, int k, double alpha, double[] a, int ia, int lda, double beta, double[] c, int ic, int ldc) {
        for (int j = 0; j < n; ++j) {
            int i;
            if (beta == 0.0) {
                for (i = j; i < n; ++i) {
                    c[ic + i + j * ldc] = 0.0;
                }
            } else if (beta != 1.0) {
                for (i = j; i < n; ++i) {
                    int n2 = ic + i + j * ldc;
                    c[n2] = c[n2] * beta;
                }
            }
            for (int l = 0; l < k; ++l) {
                if (a[ia + j + l * lda] == 0.0) continue;
                double temp = alpha * a[ia + j + l * lda];
                for (int i2 = j; i2 < n; ++i2) {
                    int n3 = ic + i2 + j * ldc;
                    c[n3] = c[n3] + temp * a[ia + i2 + l * lda];
                }
            }
        }
    }

    private void fn_notrans_upper(int n, int k, double alpha, double[] a, int ia, int lda, double beta, double[] c, int ic, int ldc) {
        for (int j = 0; j < n; ++j) {
            int i;
            if (beta == 0.0) {
                for (i = 0; i <= j; ++i) {
                    c[ic + i + j * ldc] = 0.0;
                }
            } else if (beta != 1.0) {
                for (i = 0; i <= j; ++i) {
                    int n2 = ic + i + j * ldc;
                    c[n2] = c[n2] * beta;
                }
            }
            for (int l = 0; l < k; ++l) {
                if (a[ia + j + l * lda] == 0.0) continue;
                double temp = alpha * a[ia + j + l * lda];
                for (int i2 = 0; i2 <= j; ++i2) {
                    int n3 = ic + i2 + j * ldc;
                    c[n3] = c[n3] + temp * a[ia + i2 + l * lda];
                }
            }
        }
    }

    private void fn_trans_lower(int n, int k, double alpha, double[] a, int ia, int lda, double beta, double[] c, int ic, int ldc) {
        for (int j = 0; j < n; ++j) {
            for (int i = j; i < n; ++i) {
                double temp = 0.0;
                for (int l = 0; l < k; ++l) {
                    temp += a[ia + l + i * lda] * a[ia + l + j * lda];
                }
                c[ic + i + j * ldc] = beta == 0.0 ? alpha * temp : alpha * temp + beta * c[ic + i + j * ldc];
            }
        }
    }

    private void fn_trans_upper(int n, int k, double alpha, double[] a, int ia, int lda, double beta, double[] c, int ic, int ldc) {
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i <= j; ++i) {
                double temp = 0.0;
                for (int l = 0; l < k; ++l) {
                    temp += a[ia + l + i * lda] * a[ia + l + j * lda];
                }
                c[ic + i + j * ldc] = beta == 0.0 ? alpha * temp : alpha * temp + beta * c[ic + i + j * ldc];
            }
        }
    }
}

