/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.tramo;

import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.modelling.RegressionTestType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class TradingDaysSpec
implements Cloneable,
InformationSetSerializable {
    public static final String AUTO = "auto";
    public static final String MAUTO = "mauto";
    public static final String PFTD = "pftd";
    public static final String TDOPTION = "option";
    public static final String LPOPTION = "leapyear";
    public static final String HOLIDAYS = "holidays";
    public static final String USER = "user";
    public static final String TEST = "test";
    public static final String TESTTYPE = "testtype";
    public static final String W = "stocktd";
    public static final double DEF_PFTD = 0.01;
    private String holidays_;
    private String[] users_;
    private TradingDaysType td_ = TradingDaysType.None;
    private boolean lp_;
    private RegressionTestType test_ = RegressionTestType.None;
    private int w_ = 0;
    private AutoMethod auto_ = AutoMethod.Unused;
    private double pftd_ = 0.01;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, AUTO), Boolean.class);
        dic.put(InformationSet.item(prefix, MAUTO), String.class);
        dic.put(InformationSet.item(prefix, PFTD), Double.class);
        dic.put(InformationSet.item(prefix, TDOPTION), String.class);
        dic.put(InformationSet.item(prefix, LPOPTION), String.class);
        dic.put(InformationSet.item(prefix, USER), String[].class);
        dic.put(InformationSet.item(prefix, HOLIDAYS), String.class);
        dic.put(InformationSet.item(prefix, W), Integer.class);
        dic.put(InformationSet.item(prefix, TESTTYPE), String.class);
    }

    public void reset() {
        this.holidays_ = null;
        this.users_ = null;
        this.td_ = TradingDaysType.None;
        this.lp_ = false;
        this.test_ = RegressionTestType.None;
        this.w_ = 0;
        this.auto_ = AutoMethod.Unused;
        this.pftd_ = 0.01;
    }

    public TradingDaysType getTradingDaysType() {
        return this.td_;
    }

    public boolean isUsed() {
        return this.isAutomatic() || this.td_ != TradingDaysType.None || this.users_ != null || this.w_ != 0;
    }

    public boolean isDefined() {
        return this.users_ != null || this.w_ != 0 && this.test_ == RegressionTestType.None || (this.lp_ || this.td_ != TradingDaysType.None) && this.test_ == RegressionTestType.None && this.auto_ == AutoMethod.Unused;
    }

    public boolean isAutomatic() {
        return this.auto_ != AutoMethod.Unused;
    }

    public void setAutomatic(boolean value) {
        this.auto_ = value ? AutoMethod.FTest : AutoMethod.Unused;
    }

    public AutoMethod getAutomaticMethod() {
        return this.auto_;
    }

    public void setAutomaticMethod(AutoMethod m) {
        this.auto_ = m;
    }

    public double getProbabibilityForFTest() {
        return this.pftd_;
    }

    public void setProbabibilityForFTest(double f) {
        if (f <= 0.0 || f > 0.1) {
            throw new IllegalArgumentException();
        }
        this.pftd_ = f;
    }

    public void setTradingDaysType(TradingDaysType value) {
        this.td_ = value;
        this.users_ = null;
        this.w_ = 0;
    }

    public boolean isLeapYear() {
        return this.lp_;
    }

    public void setLeapYear(boolean value) {
        this.lp_ = value;
    }

    public void setStockTradingDays(int w) {
        this.w_ = w;
        this.holidays_ = null;
        this.users_ = null;
        this.td_ = TradingDaysType.None;
        this.lp_ = false;
        this.auto_ = AutoMethod.Unused;
        this.pftd_ = 0.01;
    }

    public boolean isStockTradingDays() {
        return this.w_ != 0;
    }

    public int getStockTradingDays() {
        return this.w_;
    }

    public boolean isValid() {
        if (this.isStockTradingDays() || this.isAutomatic()) {
            return true;
        }
        if (this.test_.isUsed()) {
            return this.td_ != TradingDaysType.None && this.lp_;
        }
        if (this.td_ == TradingDaysType.None) {
            return !this.lp_;
        }
        return true;
    }

    public String getHolidays() {
        return this.holidays_;
    }

    public void setHolidays(String value) {
        this.holidays_ = value;
        if (this.holidays_ != null && this.holidays_.length() == 0) {
            this.holidays_ = null;
        }
        if (this.holidays_ != null) {
            this.users_ = null;
        }
    }

    public String[] getUserVariables() {
        return this.users_;
    }

    public void setUserVariables(String[] value) {
        this.users_ = value;
        if (this.users_ != null) {
            this.holidays_ = null;
            this.td_ = TradingDaysType.None;
            this.lp_ = false;
            this.auto_ = AutoMethod.Unused;
            this.pftd_ = 0.01;
            this.w_ = 0;
        }
    }

    public boolean isTest() {
        return this.test_.isUsed();
    }

    public void setTest(boolean test) {
        this.test_ = test ? RegressionTestType.Separate_T : RegressionTestType.None;
    }

    public RegressionTestType getRegressionTestType() {
        return this.test_;
    }

    public void setRegressionTestType(RegressionTestType value) {
        this.test_ = value;
    }

    public boolean isDefault() {
        return this.auto_ == AutoMethod.Unused && this.w_ == 0 && this.td_ == TradingDaysType.None && !this.lp_ && this.holidays_ == null && this.users_ == null;
    }

    public TradingDaysSpec clone() {
        try {
            TradingDaysSpec spec = (TradingDaysSpec)super.clone();
            if (this.users_ != null) {
                spec.users_ = (String[])this.users_.clone();
            }
            return spec;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof TradingDaysSpec && this.equals((TradingDaysSpec)obj);
    }

    private boolean equals(TradingDaysSpec other) {
        if (!Arrays.deepEquals(this.users_, other.users_) || !Objects.equals(this.holidays_, other.holidays_) || this.w_ != other.w_ || this.auto_ != other.auto_) {
            return false;
        }
        if (this.auto_ != AutoMethod.Unused) {
            return this.pftd_ == other.pftd_;
        }
        return this.td_ == other.td_ && this.lp_ == other.lp_ && this.test_ == other.test_;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode((Object)this.td_);
        hash = 97 * hash + (this.lp_ ? 1 : 0);
        return hash;
    }

    public void disable() {
        this.holidays_ = null;
        this.users_ = null;
        this.td_ = TradingDaysType.None;
        this.test_ = RegressionTestType.None;
        this.lp_ = false;
        this.w_ = 0;
        this.auto_ = AutoMethod.Unused;
    }

    @Override
    public InformationSet write(boolean verbose) {
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.auto_ != AutoMethod.Unused) {
            info.add(MAUTO, this.auto_.name());
        }
        if (verbose || this.pftd_ != 0.01) {
            info.add(PFTD, Double.valueOf(this.pftd_));
        }
        if (verbose || this.td_ != TradingDaysType.None) {
            info.add(TDOPTION, this.td_.name());
        }
        if (verbose || this.lp_) {
            info.add(LPOPTION, Boolean.valueOf(this.lp_));
        }
        if (this.holidays_ != null) {
            info.add(HOLIDAYS, this.holidays_);
        }
        if (this.users_ != null) {
            info.add(USER, this.users_);
        }
        if (verbose || this.w_ != 0) {
            info.add(W, Integer.valueOf(this.w_));
        }
        if (verbose || this.test_.isUsed()) {
            info.add(TESTTYPE, this.test_.name());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String testtype;
            Boolean test;
            Boolean lp;
            String td;
            Double pftd;
            String mauto;
            this.reset();
            Boolean auto = info.get(AUTO, Boolean.class);
            if (auto != null) {
                this.setAutomatic(auto);
            }
            if ((mauto = info.get(MAUTO, String.class)) != null) {
                this.auto_ = AutoMethod.valueOf(mauto);
            }
            if ((pftd = info.get(PFTD, Double.class)) != null) {
                this.pftd_ = pftd;
            }
            if ((td = info.get(TDOPTION, String.class)) != null) {
                this.td_ = TradingDaysType.valueOf(td);
            }
            if ((lp = info.get(LPOPTION, Boolean.class)) != null) {
                this.lp_ = lp;
            }
            this.holidays_ = info.get(HOLIDAYS, String.class);
            this.users_ = info.get(USER, String[].class);
            Integer w = info.get(W, Integer.class);
            if (w != null) {
                this.w_ = w;
            }
            if ((test = info.get(TEST, Boolean.class)) != null && test.booleanValue()) {
                this.test_ = RegressionTestType.Separate_T;
            }
            if ((testtype = info.get(TESTTYPE, String.class)) != null) {
                this.test_ = RegressionTestType.valueOf(testtype);
            }
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    public static enum AutoMethod {
        Unused,
        FTest,
        WaldTest;

    }
}

