/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.x11.DefaultSeasonalFilteringStrategy;
import ec.satoolkit.x11.X11Kernel;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class X11Results
implements ISaResults {
    public static final String SEASONALITY = "seasonality";
    public static final String TRENDFILTER = "trendfilter";
    public static final String SEASFILTER = "seasfilter";
    private DefaultSeriesDecomposition decomposition;
    private InformationSet info_;
    private static final InformationMapping<X11Results> MAPPING = new InformationMapping<X11Results>(X11Results.class);

    public X11Results(DecompositionMode mode, InformationSet info) {
        this.info_ = info;
        this.decomposition = new DefaultSeriesDecomposition(mode);
        TsData d10 = info.subSet("d-tables").get("d10_lin", TsData.class);
        TsData d10a = info.subSet("d-tables").get("d10a_lin", TsData.class);
        TsData b1 = info.subSet("b-tables").get("b1", TsData.class);
        TsDomain cdom = d10.getDomain();
        TsDomain fdom = d10a.getDomain();
        this.decomposition.add(b1.fittoDomain(cdom), ComponentType.Series);
        TsData fb1 = b1.fittoDomain(fdom);
        fb1 = fb1.cleanExtremities();
        if (!fb1.isEmpty()) {
            this.decomposition.add(fb1, ComponentType.Series, ComponentInformation.Forecast);
        }
        this.decomposition.add(info.subSet("d-tables").get("d11_lin", TsData.class), ComponentType.SeasonallyAdjusted);
        TsData sal = info.subSet("d-tables").get("d11a_lin", TsData.class);
        this.decomposition.add(sal, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
        this.decomposition.add(info.subSet("d-tables").get("d12_lin", TsData.class), ComponentType.Trend);
        this.decomposition.add(d10, ComponentType.Seasonal);
        this.decomposition.add(d10a, ComponentType.Seasonal, ComponentInformation.Forecast);
        TsData tl = info.subSet("d-tables").get("d12a_lin", TsData.class);
        this.decomposition.add(tl, ComponentType.Trend, ComponentInformation.Forecast);
        this.decomposition.add(info.subSet("d-tables").get("d13_lin", TsData.class), ComponentType.Irregular);
        TsData il = this.decomposition.getMode() == DecompositionMode.Additive ? TsData.subtract(sal, tl) : TsData.divide(sal, tl);
        this.decomposition.add(il, ComponentType.Irregular, ComponentInformation.Forecast);
    }

    public String getFinalSeasonalFilter() {
        InformationSet dtables = this.info_.getSubSet("d-tables");
        return dtables.get("d9filter", String.class);
    }

    public DefaultSeasonalFilteringStrategy[] getFinalSeasonalFilterComposit() {
        InformationSet dtables = this.info_.getSubSet("d-tables");
        return dtables.get("d9filtercomposit", DefaultSeasonalFilteringStrategy[].class);
    }

    public String getFinalTrendFilter() {
        InformationSet dtables = this.info_.getSubSet("d-tables");
        return dtables.get("d12filter", String.class);
    }

    @Override
    public ISeriesDecomposition getSeriesDecomposition() {
        return this.decomposition;
    }

    @Override
    public InformationSet getInformation() {
        return this.info_;
    }

    @Override
    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> dictionary = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, dictionary, false);
        this.info_.fillDictionary(null, dictionary);
        return dictionary;
    }

    @Override
    public boolean contains(String id) {
        if (MAPPING.contains(id)) {
            return true;
        }
        if (this.info_ != null) {
            if (!id.contains(InformationSet.STRSEP)) {
                return this.info_.deepSearch(id, Object.class) != null;
            }
            return this.info_.search(id, Object.class) != null;
        }
        return false;
    }

    @Override
    public <T> T getData(String id, Class<T> tclass) {
        if (MAPPING.contains(id)) {
            return MAPPING.getData(this, id, tclass);
        }
        if (!id.contains(InformationSet.STRSEP)) {
            return this.info_.deepSearch(id, tclass);
        }
        return this.info_.search(id, tclass);
    }

    @Override
    public <T> Map<String, T> searchAll(String wc, Class<T> tclass) {
        Map<String, T> all = MAPPING.searchAll(this, wc, tclass);
        if (this.info_ != null) {
            List<Information<T>> sel = this.info_.select(wc, tclass);
            for (Information<T> info : sel) {
                all.put(info.name, info.value);
            }
        }
        return all;
    }

    @Override
    public List<ProcessingInformation> getProcessingInformation() {
        return Collections.emptyList();
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic, boolean compact) {
        String code;
        int i;
        MAPPING.fillDictionary(prefix, dic, compact);
        for (i = 0; i < X11Kernel.ALL_A.length; ++i) {
            code = InformationSet.concatenate("a-tables", X11Kernel.ALL_A[i]);
            dic.put(InformationSet.item(prefix, code), TsData.class);
        }
        for (i = 0; i < X11Kernel.ALL_B.length; ++i) {
            code = InformationSet.concatenate("b-tables", X11Kernel.ALL_B[i]);
            dic.put(InformationSet.item(prefix, code), TsData.class);
        }
        for (i = 0; i < X11Kernel.ALL_C.length; ++i) {
            code = InformationSet.concatenate("c-tables", X11Kernel.ALL_C[i]);
            dic.put(InformationSet.item(prefix, code), TsData.class);
        }
        for (i = 0; i < X11Kernel.ALL_D.length; ++i) {
            code = InformationSet.concatenate("d-tables", X11Kernel.ALL_D[i]);
            dic.put(InformationSet.item(prefix, code), TsData.class);
        }
        for (i = 0; i < X11Kernel.ALL_E.length; ++i) {
            code = InformationSet.concatenate("e-tables", X11Kernel.ALL_E[i]);
            dic.put(InformationSet.item(prefix, code), TsData.class);
        }
    }

    public static InformationMapping<X11Results> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<X11Results, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<X11Results, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    static {
        MAPPING.set("y_cmp", source -> source.decomposition.getSeries(ComponentType.Series, ComponentInformation.Value));
        MAPPING.set("y_cmp_f", source -> source.decomposition.getSeries(ComponentType.Series, ComponentInformation.Forecast));
        MAPPING.set("t_cmp", source -> source.decomposition.getSeries(ComponentType.Trend, ComponentInformation.Value));
        MAPPING.set("t_cmp_f", source -> source.decomposition.getSeries(ComponentType.Trend, ComponentInformation.Forecast));
        MAPPING.set("sa_cmp", source -> source.decomposition.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value));
        MAPPING.set("s_cmp", source -> source.decomposition.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
        MAPPING.set("s_cmp_f", source -> source.decomposition.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast));
        MAPPING.set("i_cmp", source -> source.decomposition.getSeries(ComponentType.Irregular, ComponentInformation.Value));
        MAPPING.set("mode", DecompositionMode.class, source -> source.decomposition.getMode());
        MAPPING.set(SEASONALITY, Boolean.class, source -> !source.getFinalSeasonalFilter().equals("None"));
        MAPPING.set(TRENDFILTER, String.class, source -> source.getFinalTrendFilter());
        MAPPING.set(SEASFILTER, String.class, source -> source.getFinalSeasonalFilter());
    }
}

