/*
 * Decompiled with CFR 0.152.
 */
package jd2.workspace.util;

import java.util.Arrays;
import jd2.workspace.util.DefaultIdAggregator;
import jd2.workspace.util.Id;
import jd2.workspace.util.IdAggregator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LinearId
implements Id {
    private static final IdAggregator DEFAULT_AGGREGATOR = new DefaultIdAggregator();
    private final String[] data_;
    private final IdAggregator aggregator_;

    public static @NonNull LinearId of(@NonNull Id id) {
        if (id instanceof LinearId) {
            return (LinearId)id;
        }
        if (id.getCount() == 0) {
            return new LinearId(null, DEFAULT_AGGREGATOR, null);
        }
        return new LinearId(id.toArray(), DEFAULT_AGGREGATOR, null);
    }

    public LinearId() {
        this(null, DEFAULT_AGGREGATOR, null);
    }

    public LinearId(String id) {
        this(new String[]{id}, DEFAULT_AGGREGATOR, null);
    }

    public LinearId(String parent, String tail) {
        this(new String[]{parent, tail}, DEFAULT_AGGREGATOR, null);
    }

    public LinearId(String ... id) {
        this((String[])id.clone(), DEFAULT_AGGREGATOR, null);
    }

    public LinearId(String[] ids, IdAggregator aggregator) {
        this(ids != null ? (String[])ids.clone() : null, aggregator, null);
    }

    private LinearId(String[] ids, IdAggregator aggregator, Void private_constructor) {
        this.data_ = ids;
        this.aggregator_ = aggregator;
    }

    @Override
    public String get(int index) {
        return this.data_[index];
    }

    @Override
    public LinearId extend(String tail) {
        int n = this.getCount();
        if (n <= 0) {
            return new LinearId(new String[]{tail}, this.aggregator_, null);
        }
        String[] ids = Arrays.copyOf(this.data_, n + 1);
        ids[n] = tail;
        return new LinearId(ids, this.aggregator_, null);
    }

    @Override
    public LinearId parent() {
        int n = this.getCount();
        if (n <= 1) {
            return new LinearId(null, this.aggregator_, null);
        }
        String[] ids = Arrays.copyOf(this.data_, n - 1);
        return new LinearId(ids, this.aggregator_, null);
    }

    @Override
    public int getCount() {
        return this.data_ == null ? 0 : this.data_.length;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof LinearId && this.equals((LinearId)obj);
    }

    private boolean equals(LinearId other) {
        return 0 == this.compareTo(other);
    }

    public int hashCode() {
        if (this.data_ == null) {
            return 0;
        }
        return this.data_[this.data_.length - 1].hashCode();
    }

    @Override
    public String toString() {
        return this.aggregator_.aggregate(this.data_);
    }

    @Override
    public String[] toArray() {
        return this.data_ != null ? (String[])this.data_.clone() : new String[]{};
    }
}

