/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.arima.estimation;

import ec.tstoolkit.arima.IArimaModel;
import ec.tstoolkit.arima.estimation.ArmaEvaluation;
import ec.tstoolkit.arima.estimation.IArmaFilter;
import ec.tstoolkit.arima.estimation.KalmanFilter;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.maths.realfunctions.ISsqFunction;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionDerivatives;
import ec.tstoolkit.maths.realfunctions.ISsqFunctionInstance;
import ec.tstoolkit.maths.realfunctions.NumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.SsqNumericalDerivatives;

public class ArmaFunction<S extends IArimaModel>
implements ISsqFunction,
IFunction {
    public final RegModel dmodel;
    public final int[] missings;
    public final IParametricMapping<S> mapper;
    public final int d;
    public IArmaFilter filter;
    public boolean ml = true;
    public boolean llog = false;
    public boolean mt = false;

    public ArmaFunction(RegModel dmodel, int d, int[] missings, IParametricMapping<S> mapper) {
        this.d = d;
        this.dmodel = dmodel;
        this.missings = missings;
        this.mapper = mapper;
        this.filter = new KalmanFilter(dmodel.getVarsCount() > 0);
    }

    @Override
    public ArmaEvaluation<S> evaluate(IReadDataBlock parameters) {
        IArimaModel tmp = (IArimaModel)this.mapper.map(parameters);
        if (tmp == null) {
            return null;
        }
        return new ArmaEvaluation<IArimaModel>(this, (IArimaModel)tmp.stationaryTransformation().stationaryModel);
    }

    @Override
    public IFunctionDerivatives getDerivatives(IFunctionInstance point) {
        return new NumericalDerivatives(this, point, false, this.mt);
    }

    @Override
    public ISsqFunctionDerivatives getDerivatives(ISsqFunctionInstance point) {
        return new SsqNumericalDerivatives(this, point, false, this.mt);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapper;
    }

    @Override
    public ISsqFunctionInstance ssqEvaluate(IReadDataBlock parameters) {
        IArimaModel tmp = (IArimaModel)this.mapper.map(parameters);
        if (tmp == null) {
            return null;
        }
        return new ArmaEvaluation<IArimaModel>(this, (IArimaModel)tmp.stationaryTransformation().stationaryModel);
    }
}

