/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.LogSign;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.random.IRandomNumberGenerator;
import ec.tstoolkit.random.JdkRNG;
import ec.tstoolkit.utilities.DoubleList;
import java.util.Arrays;
import java.util.Random;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;

public final class DataBlock
implements IDataBlock,
Cloneable {
    public static final DataBlock EMPTY = new DataBlock(null, 0, 0, 0);
    private static final IRandomNumberGenerator RNG = JdkRNG.newRandom();
    final double[] src;
    final int inc;
    int beg;
    int end;
    public static final double ZERO = 0.0;
    public static final double ONE = 1.0;
    public static final double EPSILON = 1.0E-15;

    public static DataBlock random(int len) {
        double[] d = new double[len];
        for (int i = 0; i < d.length; ++i) {
            d[i] = RNG.nextDouble();
        }
        return new DataBlock(d);
    }

    public static DataBlock of(IReadDataBlock data) {
        if (data == null || data.getLength() == 0) {
            return EMPTY;
        }
        return new DataBlock(data);
    }

    public DataBlock(double[] data) {
        this.src = data;
        this.beg = 0;
        this.inc = 1;
        this.end = data != null ? data.length : 0;
    }

    public DataBlock(double[] data, int beg, int end, int inc) {
        this.src = data;
        this.beg = beg;
        this.end = end;
        this.inc = inc;
    }

    public DataBlock(int n) {
        this.src = new double[n];
        this.beg = 0;
        this.end = n;
        this.inc = 1;
    }

    public DataBlock(IReadDataBlock data) {
        this.src = new double[data.getLength()];
        data.copyTo(this.src, 0);
        this.beg = 0;
        this.end = this.src.length;
        this.inc = 1;
    }

    public static DataBlock create(double[] data, int istart, int len, int inc) {
        return new DataBlock(data, istart, istart + len * inc, inc);
    }

    public static DataBlock create(int n) {
        return n <= 0 ? EMPTY : new DataBlock(n);
    }

    public static DataBlock select(IReadDataBlock data, boolean[] sel) {
        int n = 0;
        for (int i = 0; i < sel.length; ++i) {
            if (!sel[i]) continue;
            ++n;
        }
        DataBlock d = new DataBlock(n);
        int j = 0;
        for (int i = 0; i < sel.length; ++i) {
            if (!sel[i]) continue;
            d.src[j++] = data.get(i);
        }
        return d;
    }

    public static DataBlock select(IReadDataBlock data, int[] isel) {
        int n = isel.length;
        DataBlock d = new DataBlock(n);
        for (int i = 0; i < n; ++i) {
            d.src[i] = data.get(isel[i]);
        }
        return d;
    }

    public static DataBlock create(double[] data, int istart, int len) {
        return new DataBlock(data, istart, istart + len, 1);
    }

    public void add(DataBlock r) {
        if (this.inc == 1 && r.inc == 1) {
            int i = this.beg;
            int j = r.beg;
            while (i != this.end) {
                int n = i++;
                this.src[n] = this.src[n] + r.src[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = r.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] + r.src[j];
                i += this.inc;
                j += r.inc;
            }
        }
    }

    public void add(double d) {
        if (d == 0.0) {
            return;
        }
        if (this.inc == 1) {
            int i = this.beg;
            while (i != this.end) {
                int n = i++;
                this.src[n] = this.src[n] + d;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                int n = i;
                this.src[n] = this.src[n] + d;
            }
        }
    }

    public void add(int idx, double d) {
        int n = this.beg + idx * this.inc;
        this.src[n] = this.src[n] + d;
    }

    public void addAY(double a, DataBlock y) {
        if (a == 0.0) {
            return;
        }
        if (a == 1.0) {
            this.add(y);
        } else if (a == -1.0) {
            this.sub(y);
        } else if (this.inc == 1 && y.inc == 1) {
            int i = this.beg;
            int j = y.beg;
            while (i != this.end) {
                int n = i++;
                this.src[n] = this.src[n] + a * y.src[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = y.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] + a * y.src[j];
                i += this.inc;
                j += y.inc;
            }
        }
    }

    public void addAXY(double a, DataBlock x, DataBlock y) {
        if (a == 0.0) {
            return;
        }
        if (a == 1.0) {
            int i = this.beg;
            int j = x.beg;
            int k = y.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] + x.src[j] * y.src[k];
                i += this.inc;
                j += x.inc;
                k += y.inc;
            }
        } else if (a == -1.0) {
            int i = this.beg;
            int j = x.beg;
            int k = y.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] - x.src[j] * y.src[k];
                i += this.inc;
                j += x.inc;
                k += y.inc;
            }
        } else {
            int i = this.beg;
            int j = x.beg;
            int k = y.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] + a * x.src[j] * y.src[k];
                i += this.inc;
                j += x.inc;
                k += y.inc;
            }
        }
    }

    public void setAY(double a, DataBlock y) {
        if (a == 0.0) {
            this.set(0.0);
            return;
        }
        if (a == 1.0) {
            this.copy(y);
            return;
        }
        if (this.inc == 1 && y.inc == 1) {
            int i = this.beg;
            int j = y.beg;
            while (i < this.end) {
                this.src[i] = a * y.src[j];
                ++i;
                ++j;
            }
        } else {
            int i = this.beg;
            int j = y.beg;
            while (i != this.end) {
                this.src[i] = a * y.src[j];
                i += this.inc;
                j += y.inc;
            }
        }
    }

    private void bshift() {
        int imax = this.end - this.inc;
        if (this.inc == 1) {
            for (int i = this.beg; i < imax; ++i) {
                this.src[i] = this.src[i + 1];
            }
        } else {
            for (int i = this.beg; i != imax; i += this.inc) {
                this.src[i] = this.src[i + this.inc];
            }
        }
    }

    public void bshift(ShiftOption option) {
        int imax = this.end - this.inc;
        switch (option) {
            case Rotate: {
                double first = this.src[this.beg];
                this.bshift();
                this.src[imax] = first;
                break;
            }
            case Zero: {
                this.bshift();
                this.src[imax] = 0.0;
                break;
            }
            case Sum: {
                this.src[imax] = this.sbshift();
                break;
            }
            case NegSum: {
                this.src[imax] = -this.sbshift();
                break;
            }
            default: {
                this.bshift();
            }
        }
    }

    public void chs() {
        if (this.inc == 1) {
            for (int i = this.beg; i != this.end; ++i) {
                this.src[i] = -this.src[i];
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.src[i] = -this.src[i];
            }
        }
    }

    public void sqrt() {
        if (this.inc == 1) {
            for (int i = this.beg; i != this.end; ++i) {
                this.src[i] = this.src[i] > 0.0 ? Math.sqrt(this.src[i]) : 0.0;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.src[i] = this.src[i] > 0.0 ? Math.sqrt(this.src[i]) : 0.0;
            }
        }
    }

    public void inv() {
        if (this.inc == 1) {
            for (int i = this.beg; i != this.end; ++i) {
                this.src[i] = 1.0 / this.src[i];
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.src[i] = 1.0 / this.src[i];
            }
        }
    }

    public void square() {
        if (this.inc == 1) {
            for (int i = this.beg; i != this.end; ++i) {
                this.src[i] = this.src[i] * this.src[i];
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.src[i] = this.src[i] * this.src[i];
            }
        }
    }

    public DataBlock clone() {
        try {
            DataBlock db = (DataBlock)super.clone();
            return db;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public void copy(DataBlock data) {
        if (this.inc == 1 && data.inc == 1) {
            System.arraycopy(data.src, data.beg, this.src, this.beg, data.getLength());
        } else {
            int i = this.beg;
            for (int j = data.beg; j != data.end; j += data.inc) {
                this.src[i] = data.src[j];
                i += this.inc;
            }
        }
    }

    @Override
    public void copy(IReadDataBlock data) {
        int n = data.getLength();
        int i = this.beg;
        for (int j = 0; j < n; ++j) {
            this.src[i] = data.get(j);
            i += this.inc;
        }
    }

    @Override
    public void copyFrom(double[] buffer, int start) {
        if (this.inc == 1) {
            System.arraycopy(buffer, start, this.src, this.beg, this.end - this.beg);
        } else {
            int t = this.beg;
            int s = start;
            while (t != this.end) {
                this.src[t] = buffer[s];
                t += this.inc;
                ++s;
            }
        }
    }

    @Override
    public void copyTo(double[] buffer, int start) {
        if (this.inc == 1) {
            System.arraycopy(this.src, this.beg, buffer, start, this.end - this.beg);
        } else {
            int s = this.beg;
            int t = start;
            while (s != this.end) {
                buffer[t] = this.src[s];
                s += this.inc;
                ++t;
            }
        }
    }

    public void cumul() {
        int cur = this.beg;
        double s = this.src[cur];
        cur += this.inc;
        while (cur != this.end) {
            this.src[cur] = s += this.src[cur];
            cur += this.inc;
        }
    }

    public void cumul(double c) {
        int cur = this.beg;
        double s = this.src[cur];
        cur += this.inc;
        while (cur != this.end) {
            this.src[cur] = s = c * s + this.src[cur];
            cur += this.inc;
        }
    }

    public void cumul(double c, int lag) {
        int cur;
        int linc = lag * this.inc;
        if (this.getLength() < lag) {
            return;
        }
        if (c == 1.0) {
            for (cur = this.beg + linc; cur != this.end; cur += this.inc) {
                int n = cur;
                this.src[n] = this.src[n] + this.src[cur - linc];
            }
        } else {
            while (cur != this.end) {
                int n = cur;
                this.src[n] = this.src[n] + c * this.src[cur - linc];
                cur += this.inc;
            }
        }
    }

    public DataBlock deepClone() {
        if (this == EMPTY) {
            return EMPTY;
        }
        DataBlock rc = new DataBlock(this.getLength());
        this.copyTo(rc.src, 0);
        return rc;
    }

    public void difference() {
        if (this.getLength() <= 1) {
            return;
        }
        int cur = this.end - this.inc;
        do {
            int n = (cur -= this.inc) + this.inc;
            this.src[n] = this.src[n] - this.src[cur];
        } while (cur != this.beg);
    }

    public void difference(DataBlock l, DataBlock r) {
        int i = this.beg;
        int j = l.beg;
        int k = r.beg;
        while (i != this.end) {
            this.src[i] = l.src[j] - r.src[k];
            i += this.inc;
            j += l.inc;
            k += r.inc;
        }
    }

    public void difference(double delta) {
        if (this.getLength() <= 1) {
            return;
        }
        int cur = this.end - this.inc;
        do {
            int n = (cur -= this.inc) + this.inc;
            this.src[n] = this.src[n] - delta * this.src[cur];
        } while (cur != this.beg);
    }

    public void difference(double c, int lag) {
        if (this.getLength() <= lag) {
            return;
        }
        int linc = this.inc * lag;
        int cur = this.end - linc;
        do {
            int n = (cur -= this.inc) + linc;
            this.src[n] = this.src[n] - c * this.src[cur];
        } while (cur != this.beg);
    }

    public double distance(DataBlock data) {
        if (this.beg == this.end) {
            return 0.0;
        }
        if (this.beg + this.inc == this.end) {
            return Math.abs(this.src[this.beg] - data.src[data.beg]);
        }
        double scale = 0.0;
        double ssq = 1.0;
        int ix = this.beg;
        int jx = data.beg;
        while (ix != this.end) {
            double d;
            double x = this.src[ix];
            double y = data.src[jx];
            if (Double.compare(x, y) != 0 && (d = x - y) != 0.0) {
                double s;
                double absxi = Math.abs(d);
                if (scale < absxi) {
                    s = scale / absxi;
                    ssq = 1.0 + ssq * s * s;
                    scale = absxi;
                } else {
                    s = absxi / scale;
                    ssq += s * s;
                }
            }
            ix += this.inc;
            jx += data.inc;
        }
        return scale * Math.sqrt(ssq);
    }

    public double dot(DataBlock data) {
        double r = 0.0;
        if (this.inc == 1 && data.inc == 1) {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                r += this.src[i] * data.src[j];
                ++i;
                ++j;
            }
        } else if (this.inc == -1 && data.inc == -1) {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                r += this.src[i] * data.src[j];
                --i;
                --j;
            }
        } else {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                r += this.src[i] * data.src[j];
                i += this.inc;
                j += data.inc;
            }
        }
        return r;
    }

    public double dot(double[] data) {
        double r = 0.0;
        if (this.inc == 1 && this.beg == 0) {
            for (int i = 0; i < data.length; ++i) {
                r += this.src[i] * data[i];
            }
        } else {
            int i = this.beg;
            for (int j = 0; j < data.length; ++j) {
                r += this.src[i] * data[j];
                i += this.inc;
            }
        }
        return r;
    }

    public double jdot(int p, DataBlock data) {
        double r = 0.0;
        int pend = this.beg + p * this.inc;
        if (this.inc == 1 && data.inc == 1) {
            int i = this.beg;
            int j = data.beg;
            while (i != pend) {
                r += this.src[i] * data.src[j];
                ++i;
                ++j;
            }
            while (i != this.end) {
                r -= this.src[i] * data.src[j];
                ++i;
                ++j;
            }
        } else if (this.inc == -1 && data.inc == -1) {
            int i = this.beg;
            int j = data.beg;
            while (i != pend) {
                r += this.src[i] * data.src[j];
                --i;
                --j;
            }
            while (i != this.end) {
                r -= this.src[i] * data.src[j];
                --i;
                --j;
            }
        } else {
            int i = this.beg;
            int j = data.beg;
            while (i != pend) {
                r += this.src[i] * data.src[j];
                i += this.inc;
                j += data.inc;
            }
            while (i != this.end) {
                r += this.src[i] * data.src[j];
                i += this.inc;
                j += data.inc;
            }
        }
        return r;
    }

    public double dotReverse(DataBlock data) {
        double r = 0.0;
        int i = this.beg;
        int j = data.end - data.inc;
        while (i != this.end) {
            r += this.src[i] * data.src[j];
            i += this.inc;
            j -= data.inc;
        }
        return r;
    }

    public double dotReverse(double[] data) {
        double r = 0.0;
        if (this.inc == 1) {
            int i = this.beg;
            for (int j = data.length - 1; j >= 0; --j) {
                r += this.src[i] * data[j];
                ++i;
            }
        } else {
            int i = this.beg;
            for (int j = data.length - 1; j >= 0; --j) {
                r += this.src[i] * data[j];
                i += this.inc;
            }
        }
        return r;
    }

    public double reverseDot(double[] data) {
        double r = 0.0;
        int m = data.length;
        if (this.inc == 1) {
            int i = this.end - 1;
            for (int j = m - 1; j >= 0; --j) {
                r += this.src[i] * data[j];
                --i;
            }
        } else {
            int i = this.end - this.inc;
            for (int j = m - 1; j >= 0; --j) {
                r += this.src[i] * data[j];
                i -= this.inc;
            }
        }
        return r;
    }

    public DataBlock drop(int nbeg, int nend) {
        return this.inc == 1 ? new DataBlock(this.src, this.beg + nbeg, this.end - nend, 1) : new DataBlock(this.src, this.beg + nbeg * this.inc, this.end - nend * this.inc, this.inc);
    }

    public boolean bshrink() {
        if (this.beg != this.end) {
            this.beg += this.inc;
            return true;
        }
        return false;
    }

    public boolean eshrink() {
        if (this.beg != this.end) {
            this.end -= this.inc;
            return true;
        }
        return false;
    }

    public boolean shrink(int nbeg, int nend) {
        if (nbeg + nend <= this.getLength()) {
            this.beg += this.inc * nbeg;
            this.end -= this.inc * nend;
            return true;
        }
        return false;
    }

    public boolean expand(int nbeg, int nend) {
        int xbeg = this.beg - nbeg * this.inc;
        int xend = this.end + nend * this.inc;
        if (xbeg < 0 || xbeg > this.src.length) {
            return false;
        }
        this.beg = xbeg;
        this.end = xend;
        return true;
    }

    public DataBlock extend(int nbeg, int nend) {
        return new DataBlock(this.src, this.beg - nbeg * this.inc, this.end + nend * this.inc, this.inc);
    }

    @Override
    public DataBlock extract(int start, int count) {
        return this.extract(start, count, 1);
    }

    public DataBlock extract(int start, int count, int inc) {
        int i1;
        int ninc;
        int i0;
        if (this.inc == 1) {
            i0 = this.beg + start;
            ninc = inc;
        } else {
            i0 = this.beg + start * this.inc;
            ninc = inc * this.inc;
        }
        if (count == -1) {
            int n = 0;
            if (this.inc > 0 && i0 <= this.end - this.inc || this.inc < 0 && i0 >= this.end - this.inc) {
                n = inc > 0 ? 1 + (this.end - this.inc - i0) / ninc : 1 + (this.beg - i0) / ninc;
            }
            i1 = i0 + n * ninc;
        } else {
            i1 = i0 + ninc * count;
        }
        return new DataBlock(this.src, i0, i1, ninc);
    }

    public void fshift(int n) {
        int i0 = this.end - this.inc;
        int i1 = this.beg + (n - 1) * this.inc;
        int ninc = n * this.inc;
        for (int i = i0; i != i1; i -= this.inc) {
            this.src[i] = this.src[i - ninc];
        }
    }

    public void bshift(int n) {
        int i0 = this.beg;
        int ninc = n * this.inc;
        int i1 = this.end - ninc;
        for (int i = i0; i != i1; i += this.inc) {
            this.src[i] = this.src[i + ninc];
        }
    }

    private void fshift() {
        if (this.inc == 1) {
            for (int i = this.end - 1; i != this.beg; --i) {
                this.src[i] = this.src[i - 1];
            }
        } else {
            for (int i = this.end - this.inc; i != this.beg; i -= this.inc) {
                this.src[i] = this.src[i - this.inc];
            }
        }
    }

    public void fshift(ShiftOption option) {
        switch (option) {
            case Rotate: {
                double last = this.src[this.end - this.inc];
                this.fshift();
                this.src[this.beg] = last;
                break;
            }
            case Zero: {
                this.fshift();
                this.src[this.beg] = 0.0;
                break;
            }
            case Sum: {
                this.src[this.beg] = this.sfshift();
                break;
            }
            case NegSum: {
                this.src[this.beg] = -this.sfshift();
                break;
            }
            default: {
                this.fshift();
            }
        }
    }

    @Override
    public double get(int idx) {
        return this.src[this.beg + this.inc * idx];
    }

    public double[] getData() {
        return this.src;
    }

    public int getEndPosition() {
        return this.end;
    }

    public int getLastPosition() {
        return this.end - this.inc;
    }

    public int getLastIndex() {
        return this.inc == 1 ? this.end - this.beg - 1 : (this.end - this.beg) / this.inc - 1;
    }

    public int getEndIndex() {
        return this.inc == 1 ? this.end - this.beg : (this.end - this.beg) / this.inc;
    }

    public int getIncrement() {
        return this.inc;
    }

    @Override
    public int getLength() {
        if (this.beg == this.end) {
            return 0;
        }
        if (this.inc == 1) {
            return this.end - this.beg;
        }
        return (this.end - this.beg) / this.inc;
    }

    public int getStartPosition() {
        return this.beg;
    }

    public boolean isConstant() {
        double d = this.src[this.beg];
        for (int i = this.beg + this.inc; i != this.end; i += this.inc) {
            if (this.src[i] == d) continue;
            return false;
        }
        return true;
    }

    public boolean isConstant(double c) {
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (this.src[i] == c) continue;
            return false;
        }
        return true;
    }

    public int getMissingCount() {
        int n = 0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (Double.isFinite(this.src[i])) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return this.beg == this.end;
    }

    public boolean isZero() {
        return this.isZero(1.0E-15);
    }

    public void move(int del) {
        if (this.inc != 1) {
            del *= this.inc;
        }
        this.beg += del;
        this.end += del;
    }

    public void mul(double d) {
        block6: {
            if (d == 1.0) break block6;
            if (d == 0.0) {
                this.set(0.0);
            } else if (this.inc == 1) {
                int i = this.beg;
                while (i != this.end) {
                    int n = i++;
                    this.src[n] = this.src[n] * d;
                }
            } else {
                for (int i = this.beg; i != this.end; i += this.inc) {
                    int n = i;
                    this.src[n] = this.src[n] * d;
                }
            }
        }
    }

    public void mul(DataBlock data) {
        if (this.inc == 1 && data.inc == 1) {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                int n = i++;
                this.src[n] = this.src[n] * data.src[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] * data.src[j];
                i += this.inc;
                j += data.inc;
            }
        }
    }

    public void div(DataBlock data) {
        if (this.inc == 1 && data.inc == 1) {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                int n = i++;
                this.src[n] = this.src[n] / data.src[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] / data.src[j];
                i += this.inc;
                j += data.inc;
            }
        }
    }

    public void div(double d) {
        this.mul(1.0 / d);
    }

    public void mul(int idx, double d) {
        int n = this.beg + idx * this.inc;
        this.src[n] = this.src[n] * d;
    }

    public double nrm2() {
        if (this.beg == this.end) {
            return 0.0;
        }
        if (this.beg + this.inc == this.end) {
            return Math.abs(this.src[this.beg]);
        }
        double scale = 0.0;
        double ssq = 1.0;
        for (int ix = this.beg; ix != this.end; ix += this.inc) {
            double s;
            if (this.src[ix] == 0.0) continue;
            double absxi = Math.abs(this.src[ix]);
            if (scale < absxi) {
                s = scale / absxi;
                ssq = 1.0 + ssq * s * s;
                scale = absxi;
                continue;
            }
            s = absxi / scale;
            ssq += s * s;
        }
        return scale * Math.sqrt(ssq);
    }

    public double nrmInf() {
        if (this.beg == this.end) {
            return 0.0;
        }
        double nrm = Math.abs(this.src[this.beg]);
        for (int ix = this.beg + this.inc; ix != this.end; ix += this.inc) {
            double tmp = Math.abs(this.src[ix]);
            if (!(tmp > nrm)) continue;
            nrm = tmp;
        }
        return nrm;
    }

    public double min() {
        if (this.beg == this.end) {
            return 0.0;
        }
        double nrm = this.src[this.beg];
        for (int ix = this.beg + this.inc; ix != this.end; ix += this.inc) {
            double tmp = this.src[ix];
            if (!(tmp < nrm)) continue;
            nrm = tmp;
        }
        return nrm;
    }

    public double max() {
        if (this.beg == this.end) {
            return 0.0;
        }
        double nrm = this.src[this.beg];
        for (int ix = this.beg + this.inc; ix != this.end; ix += this.inc) {
            double tmp = this.src[ix];
            if (!(tmp > nrm)) continue;
            nrm = tmp;
        }
        return nrm;
    }

    public double product() {
        double s = 1.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            s *= this.src[i];
        }
        return s;
    }

    public void product(DataBlock row, DataBlockIterator cols) {
        int idx = this.beg;
        DataBlock cur = cols.getData();
        do {
            this.src[idx] = row.dot(cur);
            idx += this.inc;
        } while (cols.next());
    }

    public void addProduct(DataBlock row, DataBlockIterator cols) {
        int idx = this.beg;
        DataBlock cur = cols.getData();
        do {
            int n = idx;
            this.src[n] = this.src[n] + row.dot(cur);
            idx += this.inc;
        } while (cols.next());
    }

    public void product(DataBlock l, double d) {
        if (d == 0.0) {
            this.set(0.0);
        } else if (d == 1.0) {
            this.copy(l);
        } else if (this.inc == 1 && l.inc == 1) {
            int i = this.beg;
            int j = l.beg;
            while (i != this.end) {
                this.src[i] = l.src[j] * d;
                ++i;
                ++j;
            }
        } else if (this.inc == -1 && l.inc == -1) {
            int i = this.beg;
            int j = l.beg;
            while (i != this.end) {
                this.src[i] = l.src[j] * d;
                --i;
                --j;
            }
        } else {
            int i = this.beg;
            int j = l.beg;
            while (i != this.end) {
                this.src[i] = l.src[j] * d;
                i += this.inc;
                j += l.inc;
            }
        }
    }

    public void product(DataBlockIterator rows, DataBlock col) {
        int idx = this.beg;
        DataBlock cur = rows.getData();
        do {
            this.src[idx] = cur.dot(col);
            idx += this.inc;
        } while (rows.next());
    }

    public void addProduct(DataBlockIterator rows, DataBlock col) {
        int idx = this.beg;
        DataBlock cur = rows.getData();
        do {
            int n = idx;
            this.src[n] = this.src[n] + cur.dot(col);
            idx += this.inc;
        } while (rows.next());
    }

    public DataBlock range(int c0, int c1) {
        if (this.inc == 1) {
            return new DataBlock(this.src, this.beg + c0, this.beg + c1, 1);
        }
        return new DataBlock(this.src, this.beg + this.inc * c0, this.beg + this.inc * c1, this.inc);
    }

    public DataBlock reverse() {
        return new DataBlock(this.src, this.end - this.inc, this.beg - this.inc, -this.inc);
    }

    @Override
    public DataBlock rextract(int start, int count) {
        return this.extract(start, count, 1);
    }

    private double sbshift() {
        int imax = this.end - this.inc;
        double s = this.src[this.beg];
        if (this.inc == 1) {
            for (int i = this.beg; i != imax; ++i) {
                this.src[i] = this.src[i + 1];
                s += this.src[i];
            }
        } else {
            for (int i = this.beg; i < imax; i += this.inc) {
                this.src[i] = this.src[i + this.inc];
                s += this.src[i];
            }
        }
        return s;
    }

    public void set(double d) {
        if (this.inc == 1) {
            Arrays.fill(this.src, this.beg, this.end, d);
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                this.src[i] = d;
            }
        }
    }

    @Override
    public void set(int idx, double value) {
        this.src[this.beg + this.inc * idx] = value;
    }

    private double sfshift() {
        double s = this.src[this.beg];
        if (this.inc == 1) {
            for (int i = this.end - 1; i != this.beg; --i) {
                s += this.src[i];
                this.src[i] = this.src[i - 1];
            }
        } else {
            for (int i = this.end - this.inc; i != this.beg; i -= this.inc) {
                s += this.src[i];
                this.src[i] = this.src[i - this.inc];
            }
        }
        return s;
    }

    public void slide(int del) {
        this.beg += del;
        this.end += del;
    }

    @Override
    public double ssq() {
        if (this.beg == this.end) {
            return 0.0;
        }
        if (this.beg + this.inc == this.end) {
            return this.src[this.beg] * this.src[this.beg];
        }
        double ssq = 0.0;
        for (int ix = this.beg; ix != this.end; ix += this.inc) {
            double x = this.src[ix];
            ssq += x * x;
        }
        return ssq;
    }

    @Override
    public double ssqc(double m) {
        if (this.beg == this.end) {
            return 0.0;
        }
        if (this.beg + this.inc == this.end) {
            double xc = this.src[this.beg] - m;
            return xc * xc;
        }
        double ssq = 0.0;
        for (int ix = this.beg; ix != this.end; ix += this.inc) {
            double x = this.src[ix] - m;
            ssq += x * x;
        }
        return ssq;
    }

    public void sub(DataBlock data) {
        if (this.inc == 1 && data.inc == 1) {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                int n = i++;
                this.src[n] = this.src[n] - data.src[j];
                ++j;
            }
        } else {
            int i = this.beg;
            int j = data.beg;
            while (i != this.end) {
                int n = i;
                this.src[n] = this.src[n] - data.src[j];
                i += this.inc;
                j += data.inc;
            }
        }
    }

    public void sub(double d) {
        if (d == 0.0) {
            return;
        }
        if (this.inc == 1) {
            int i = this.beg;
            while (i != this.end) {
                int n = i++;
                this.src[n] = this.src[n] - d;
            }
        } else {
            for (int i = this.beg; i != this.end; i += this.inc) {
                int n = i;
                this.src[n] = this.src[n] - d;
            }
        }
    }

    @Override
    public double sum() {
        double s = 0.0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            s += this.src[i];
        }
        return s;
    }

    public void sum(DataBlock l, DataBlock r) {
        int i = this.beg;
        int j = l.beg;
        int k = r.beg;
        while (i != this.end) {
            this.src[i] = l.src[j] + r.src[k];
            i += this.inc;
            j += l.inc;
            k += r.inc;
        }
    }

    public LogSign sumLog() {
        LogSign ls = new LogSign();
        ls.value = 0.0;
        ls.pos = true;
        for (int i = this.beg; i != this.end; i += this.inc) {
            double x = this.src[i];
            if (x < 0.0) {
                ls.pos = !ls.pos;
                x = -x;
            }
            ls.value += Math.log(x);
        }
        return ls;
    }

    public static double hypot(double a, double b) {
        double z;
        double w;
        double xb;
        double xa = Math.abs(a);
        if (xa > (xb = Math.abs(b))) {
            w = xa;
            z = xb;
        } else {
            w = xb;
            z = xa;
        }
        if (z == 0.0) {
            return w;
        }
        double zw = z / w;
        return w * Math.sqrt(1.0 + zw * zw);
    }

    public void round(int ndec) {
        int i;
        if (ndec < 0) {
            throw new IllegalArgumentException("Negative rounding parameter");
        }
        double f = 1.0;
        for (i = 0; i < ndec; ++i) {
            f *= 10.0;
        }
        for (i = this.beg; i != this.end; i += this.inc) {
            this.src[i] = ndec > 0 ? (double)Math.round(this.src[i] * f) / f : (double)Math.round(this.src[i]);
        }
    }

    public String toString() {
        return ReadDataBlock.toString(this);
    }

    public String toString(String fmt) {
        return ReadDataBlock.toString(this, fmt);
    }

    public void randomize() {
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.src[i] = RNG.nextDouble() - 0.5;
        }
    }

    public void randomize(int seed) {
        Random rnd = new Random(seed);
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.src[i] = rnd.nextDouble() - 0.5;
        }
    }

    public boolean isZero(double zero) {
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (!(Math.abs(this.src[i]) > zero)) continue;
            return false;
        }
        return true;
    }

    public void next(int nitems) {
        this.beg = this.end;
        this.end += this.inc * nitems;
    }

    public void previous(int nitems) {
        this.end = this.beg;
        this.beg -= this.inc * nitems;
    }

    public DataBlock start() {
        return new DataBlock(this.src, this.beg, this.beg, this.inc);
    }

    public DataBlock end() {
        return new DataBlock(this.src, this.end, this.end, this.inc);
    }

    @Override
    public double computeRecursively(double initial, DoubleBinaryOperator fn) {
        double cur = initial;
        for (int i = this.beg; i != this.end; i += this.inc) {
            cur = fn.applyAsDouble(cur, this.src[i]);
        }
        return cur;
    }

    @Override
    public void apply(DoubleUnaryOperator fn) {
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.src[i] = fn.applyAsDouble(this.src[i]);
        }
    }

    @Override
    public void applyIf(DoublePredicate pred, DoubleUnaryOperator fn) {
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.src[i];
            if (!pred.test(cur)) continue;
            this.src[i] = fn.applyAsDouble(cur);
        }
    }

    @Override
    public void applyRecursively(double initial, DoubleBinaryOperator fn) {
        double cur = initial;
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.src[i] = cur = fn.applyAsDouble(cur, this.src[i]);
        }
    }

    @Override
    public boolean check(DoublePredicate pred) {
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (pred.test(this.src[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int count(DoublePredicate pred) {
        int n = 0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (!pred.test(this.src[i])) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int first(DoublePredicate pred) {
        for (int i = this.beg; i != this.end; i += this.inc) {
            if (!pred.test(this.src[i])) continue;
            return (i - this.beg) / this.inc;
        }
        return this.getLength();
    }

    @Override
    public int last(DoublePredicate pred) {
        for (int i = this.end - this.inc; i != this.beg - this.inc; i -= this.inc) {
            if (!pred.test(this.src[i])) continue;
            return (i - this.beg) / this.inc;
        }
        return -1;
    }

    public void apply(DoubleBinaryOperator fn, DataBlock x) {
        int i = this.beg;
        int j = x.beg;
        while (i != this.end) {
            this.src[i] = fn.applyAsDouble(this.src[i], x.src[j]);
            i += this.inc;
            j += this.inc;
        }
    }

    @Override
    public void apply(IReadDataBlock x, DoubleBinaryOperator fn) {
        int i = this.beg;
        int j = 0;
        while (i != this.end) {
            this.src[i] = fn.applyAsDouble(this.src[i], x.get(j));
            i += this.inc;
            ++j;
        }
    }

    @Override
    public void set(DoubleSupplier fn) {
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.src[i] = fn.getAsDouble();
        }
    }

    @Override
    public void set(IntToDoubleFunction fn) {
        int j = 0;
        for (int i = this.beg; i != this.end; i += this.inc) {
            this.src[i] = fn.applyAsDouble(j++);
        }
    }

    public void set(DoubleUnaryOperator fn, DataBlock x) {
        int i = this.beg;
        int j = x.beg;
        while (i != this.end) {
            this.src[i] = fn.applyAsDouble(x.src[j]);
            i += this.inc;
            j += x.inc;
        }
    }

    @Override
    public void set(IReadDataBlock x, DoubleUnaryOperator fn) {
        int i = this.beg;
        int j = 0;
        while (i != this.end) {
            this.src[i] = fn.applyAsDouble(x.get(j));
            i += this.inc;
            ++j;
        }
    }

    @Override
    public void setIf(DoublePredicate pred, DoubleSupplier fn) {
        int i = this.beg;
        int j = 0;
        while (i != this.end) {
            if (pred.test(this.src[i])) {
                this.src[i] = fn.getAsDouble();
            }
            i += this.inc;
            ++j;
        }
    }

    public void set(DataBlock x, DataBlock y, DoubleBinaryOperator fn) {
        int i = this.beg;
        int j = x.beg;
        int k = y.beg;
        while (i != this.end) {
            this.src[i] = fn.applyAsDouble(x.src[j], y.src[k]);
            i += this.inc;
            j += x.inc;
            k += y.inc;
        }
    }

    @Override
    public void set(IReadDataBlock x, IReadDataBlock y, DoubleBinaryOperator fn) {
        int i = this.beg;
        int j = 0;
        while (i != this.end) {
            this.src[i] = fn.applyAsDouble(x.get(j), y.get(j));
            i += this.inc;
            ++j;
        }
    }

    public DataBlock select(DoublePredicate pred) {
        DoubleList list = new DoubleList();
        for (int i = this.beg; i != this.end; i += this.inc) {
            double cur = this.src[i];
            if (!pred.test(cur)) continue;
            list.add(cur);
        }
        return new DataBlock(list.toArray());
    }

    public static DataBlock select(IReadDataBlock data, DoublePredicate pred) {
        DoubleList list = new DoubleList();
        int n = data.getLength();
        for (int i = 0; i < n; ++i) {
            double cur = data.get(i);
            if (!pred.test(cur)) continue;
            list.add(cur);
        }
        return new DataBlock(list.toArray());
    }

    public static enum ShiftOption {
        None,
        Rotate,
        Zero,
        Sum,
        NegSum;

    }
}

