/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.utilities.IntList;

public class Periodogram {
    private double m_sy;
    private double m_sy2;
    private int m_n;
    private int[] m_w;
    private double[] m_data;
    private double[] m_p;
    private double[] m_s;
    private final boolean m_mean;

    public static double[] getSeasonalFrequencies(int freq) {
        double[] dfreq = new double[freq / 2];
        for (int i = 1; i <= dfreq.length; ++i) {
            dfreq[i - 1] = Math.PI * 2 * (double)i / (double)freq;
        }
        return dfreq;
    }

    public static double[] getTradingDaysFrequencies(int freq) {
        double n = 365.25 / (double)freq;
        double f = 0.8975979010256552 * (n - 7.0 * Math.floor(n / 7.0));
        if (f > Math.PI) {
            f = Math.PI * 2 - f;
        }
        if (freq == 12) {
            return new double[]{f};
        }
        if (freq == 4) {
            return new double[]{f, 1.292, 1.85, 2.128};
        }
        return new double[]{f};
    }

    public Periodogram(IReadDataBlock data) {
        this(data, true);
    }

    public Periodogram(IReadDataBlock data, boolean mean) {
        block4: {
            block3: {
                int i;
                this.calcwnd(1);
                this.m_data = new double[data.getLength()];
                data.copyTo(this.m_data, 0);
                this.m_mean = mean;
                if (!this.m_mean) break block3;
                this.m_sy = 0.0;
                this.m_n = 0;
                for (i = 0; i < this.m_data.length; ++i) {
                    if (Double.isNaN(this.m_data[i])) continue;
                    ++this.m_n;
                    this.m_sy += this.m_data[i];
                }
                if (this.m_n <= 0) break block4;
                this.m_sy /= (double)this.m_n;
                this.m_sy2 = 0.0;
                for (i = 0; i < this.m_data.length; ++i) {
                    if (Double.isNaN(this.m_data[i])) continue;
                    int n = i;
                    this.m_data[n] = this.m_data[n] - this.m_sy;
                    this.m_sy2 += this.m_data[i] * this.m_data[i];
                }
                break block4;
            }
            this.m_n = 0;
            this.m_sy2 = 0.0;
            for (int i = 0; i < this.m_data.length; ++i) {
                if (Double.isNaN(this.m_data[i])) continue;
                ++this.m_n;
                this.m_sy += this.m_data[i];
                this.m_sy2 += this.m_data[i] * this.m_data[i];
            }
        }
    }

    public boolean isMeanCorrection() {
        return this.m_mean;
    }

    public double getSsq() {
        return this.m_sy2;
    }

    private void calcp() {
        int i;
        if (this.m_p != null || this.m_data == null) {
            return;
        }
        int T2 = this.m_data.length;
        int T1 = (1 + T2) / 2;
        int T22 = 1 + T2 / 2;
        this.m_p = new double[T22];
        double l = Math.PI * 2 / (double)T2;
        double cosl = Math.cos(l);
        double sinl = Math.sin(l);
        double cos = 1.0;
        double sin = 0.0;
        this.m_p[0] = this.m_mean ? 0.0 : this.m_sy * this.m_sy / this.m_sy2;
        double a = 0.0;
        double b = 0.0;
        for (i = 1; i < T1; ++i) {
            double ctmp = cos;
            double stmp = sin;
            sin = cosl * stmp + sinl * ctmp;
            cos = -sinl * stmp + cosl * ctmp;
            a = 0.0;
            b = 0.0;
            double c = 1.0;
            double s = 0.0;
            for (int j = 0; j < T2; ++j) {
                ctmp = c;
                stmp = s;
                s = cos * stmp + sin * ctmp;
                c = -sin * stmp + cos * ctmp;
                if (Double.isNaN(this.m_data[j])) continue;
                a += c * this.m_data[j];
                b += s * this.m_data[j];
            }
            this.m_p[i] = 2.0 * (a * a + b * b) / this.m_sy2;
        }
        if (T1 != T22) {
            a = 0.0;
            for (i = 0; i < T2; ++i) {
                if (Double.isNaN(this.m_data[i])) continue;
                if (i % 2 == 0) {
                    a += this.m_data[i];
                    continue;
                }
                a -= this.m_data[i];
            }
            this.m_p[T22 - 1] = a * a / this.m_sy2;
        }
    }

    private void calcs() {
        int i;
        if (this.m_s != null || this.m_data == null) {
            return;
        }
        this.calcp();
        if (this.m_p.length < this.m_w.length) {
            return;
        }
        if (this.m_w.length == 1) {
            this.m_s = this.m_p;
            return;
        }
        this.m_s = new double[this.m_p.length];
        double wt = this.m_w[0];
        int nw = this.m_w.length;
        for (i = 1; i < nw; ++i) {
            wt += (double)(2 * this.m_w[i]);
        }
        for (i = nw - 1; i < this.m_p.length - nw; ++i) {
            double s = 0.0;
            for (int j = 1 - nw; j < nw; ++j) {
                s += this.m_p[i + j] * (double)this.m_w[Math.abs(j)];
            }
            this.m_s[i] = s /= wt;
        }
        int plast = this.m_p.length - 1;
        for (int i2 = 0; i2 < nw; ++i2) {
            wt = 0.0;
            double sbeg = 0.0;
            double send = 0.0;
            for (int j = -i2; j < nw; ++j) {
                double w = this.m_w[Math.abs(j)];
                sbeg += this.m_p[i2 + j] * w;
                send += this.m_p[plast - i2 - j] * w;
                wt += w;
            }
            this.m_s[i2] = sbeg / wt;
            this.m_s[plast - i2] = send / wt;
        }
    }

    private void calcwnd(int n) {
        if (n < 1) {
            throw new BaseException("Invalid Window length");
        }
        if (n == 1) {
            this.m_w = new int[]{1};
        } else {
            this.m_w = new int[n];
            this.m_w[n - 1] = 1;
            this.m_w[n - 2] = 2;
            int c = n - 2;
            while (c > 0) {
                int k;
                for (k = c; k < n - 1; ++k) {
                    int n2 = k;
                    this.m_w[n2] = this.m_w[n2] + this.m_w[k + 1];
                }
                this.m_w[c - 1] = this.m_w[c];
                for (k = --c; k < n - 1; ++k) {
                    int n3 = k;
                    this.m_w[n3] = this.m_w[n3] + this.m_w[k + 1];
                }
            }
        }
    }

    public double[] getData() {
        return this.m_data;
    }

    public double getIntervalInRadians() {
        return this.m_data == null ? 0.0 : Math.PI * 2 / (double)(this.m_data.length - 1);
    }

    public double[] getP() {
        this.calcp();
        return this.m_p;
    }

    public double[] getS() {
        this.calcs();
        return this.m_s;
    }

    public int getWindowLength() {
        return this.m_w == null ? 0 : this.m_w.length;
    }

    public int[] searchPeaks(double dMin, boolean smoothed) {
        if (!smoothed) {
            this.calcp();
            IntList peaks = new IntList(this.m_p.length);
            for (int i = 0; i < this.m_p.length; ++i) {
                if (!(this.m_p[i] > dMin)) continue;
                peaks.add(i);
            }
            return peaks.toArray();
        }
        this.calcs();
        IntList peaks = new IntList(this.m_s.length);
        for (int i = 0; i < this.m_s.length; ++i) {
            if (!(this.m_s[i] > dMin)) continue;
            peaks.add(i);
        }
        return peaks.toArray();
    }

    public void setWindowLength(int value) {
        if (this.m_w == null || value != this.m_w.length) {
            this.calcwnd(value);
            this.m_s = null;
        }
    }
}

