/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima;

import ec.tstoolkit.arima.estimation.RegArimaModel;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.ReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.maths.realfunctions.IParametricMapping;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.PreadjustmentVariable;
import ec.tstoolkit.modelling.RegStatus;
import ec.tstoolkit.modelling.Variable;
import ec.tstoolkit.modelling.arima.PreadjustmentType;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.sarima.SarimaModel;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.estimation.SarimaFixedMapping;
import ec.tstoolkit.sarima.estimation.SarimaMapping;
import ec.tstoolkit.timeseries.TsException;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.ICalendarVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IMovingHolidayVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.IUserTsVariable;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.ConstTransformation;
import ec.tstoolkit.timeseries.simplets.ExpTransformation;
import ec.tstoolkit.timeseries.simplets.ITsDataInterpolator;
import ec.tstoolkit.timeseries.simplets.ITsDataTransformation;
import ec.tstoolkit.timeseries.simplets.LengthOfPeriodTransformation;
import ec.tstoolkit.timeseries.simplets.LogTransformation;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import ec.tstoolkit.utilities.IntList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelDescription
implements Cloneable {
    private final TsData original_;
    private final TsDomain estimationDomain_;
    private double[] y0_;
    private double[] y_;
    private int[] missings_;
    private SarimaComponent arima_ = new SarimaComponent();
    private List<PreadjustmentVariable> preadjustment = new ArrayList<PreadjustmentVariable>();
    private List<Variable> variables = new ArrayList<Variable>();
    private double units_ = 1.0;
    private PreadjustmentType adjust_ = PreadjustmentType.None;
    private volatile LengthOfPeriodType lp_ = LengthOfPeriodType.None;
    private volatile int diff_;
    private DefaultTransformationType function_ = DefaultTransformationType.None;
    private double logtransform0_;
    private double logtransform_;
    private final HashMap<ITsVariable, DataBlock[]> xmap_ = new HashMap();

    public ModelDescription(TsData originalTs, TsDomain eDomain) {
        this.original_ = originalTs;
        this.estimationDomain_ = eDomain == null ? this.original_.getDomain() : this.original_.getDomain().intersection(eDomain);
        this.y0_ = this.original_.fittoDomain(this.estimationDomain_).internalStorage();
    }

    public ModelDescription clone() {
        try {
            ModelDescription model = (ModelDescription)super.clone();
            model.preadjustment = new ArrayList<PreadjustmentVariable>();
            for (PreadjustmentVariable preadjustmentVariable : this.preadjustment) {
                model.preadjustment.add(preadjustmentVariable);
            }
            model.variables = new ArrayList<Variable>();
            for (Variable variable : this.variables) {
                model.variables.add(variable.clone());
            }
            model.arima_ = this.arima_.clone();
            return model;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    void invalidateData() {
        this.logtransform_ = 0.0;
        this.y_ = null;
        this.lp_ = LengthOfPeriodType.None;
    }

    private List<DataBlock> createX() {
        this.checkVariables();
        ArrayList<DataBlock> xdata = new ArrayList<DataBlock>();
        this.variables.stream().filter(var -> var.isUser() && var.status.isSelected()).forEach(var -> {
            DataBlock[] cur = this.getX(var.getVariable());
            Collections.addAll(xdata, cur);
        });
        this.variables.stream().filter(var -> var.isCalendar() && var.status.isSelected()).forEach(var -> {
            DataBlock[] cur = this.getX(var.getVariable());
            Collections.addAll(xdata, cur);
        });
        this.variables.stream().filter(var -> var.isMovingHoliday() && var.status.isSelected()).forEach(var -> {
            DataBlock[] cur = this.getX(var.getVariable());
            Collections.addAll(xdata, cur);
        });
        this.variables.stream().filter(var -> var.isOutlier() && var.status == RegStatus.Prespecified).forEach(var -> {
            DataBlock[] cur = this.getX(var.getVariable());
            Collections.addAll(xdata, cur);
        });
        this.variables.stream().filter(var -> var.isOutlier() && var.status != RegStatus.Prespecified).forEach(var -> {
            DataBlock[] cur = this.getX(var.getVariable());
            Collections.addAll(xdata, cur);
        });
        return xdata;
    }

    public void checkVariables() {
        for (Variable var : this.variables) {
            if (!var.status.isSelected() || var.getVariable().isSignificant(this.estimationDomain_)) continue;
            var.status = RegStatus.Excluded;
        }
    }

    public IParametricMapping<SarimaModel> defaultMapping() {
        if (this.arima_.getFixedParametersCount() == 0) {
            return new SarimaMapping(this.arima_.getSpecification(), false);
        }
        return new SarimaFixedMapping(this.arima_.getSpecification(), this.arima_.getParameters(), this.arima_.getFixedConstraints());
    }

    public List<Variable> getOrderedVariables() {
        this.checkVariables();
        ArrayList<Variable> x = new ArrayList<Variable>();
        this.variables.stream().filter(var -> var.isUser() && var.status.isSelected()).forEach(var -> x.add((Variable)var));
        this.variables.stream().filter(var -> var.isCalendar() && var.status.isSelected()).forEach(var -> x.add((Variable)var));
        this.variables.stream().filter(var -> var.isMovingHoliday() && var.status.isSelected()).forEach(var -> x.add((Variable)var));
        this.variables.stream().filter(var -> var.isOutlier() && var.status == RegStatus.Prespecified).forEach(var -> x.add((Variable)var));
        this.variables.stream().filter(var -> var.isOutlier() && var.status != RegStatus.Prespecified).forEach(var -> x.add((Variable)var));
        return x;
    }

    public TsVariableList buildRegressionVariables() {
        TsVariableList x = new TsVariableList();
        List<Variable> vars = this.getOrderedVariables();
        for (Variable var : vars) {
            x.add(var.getVariable());
        }
        return x;
    }

    public TsVariableSelection buildRegressionVariables(Predicate<Variable> pred) {
        this.checkVariables();
        TsVariableSelection<ITsVariable> x = new TsVariableSelection<ITsVariable>();
        int cur = 0;
        for (Variable var : this.variables) {
            if (!var.isUser() || !var.status.isSelected()) continue;
            if (pred.test(var)) {
                x.add(var.getVariable(), cur);
            }
            cur += var.getVariable().getDim();
        }
        for (Variable var : this.variables) {
            if (!var.isCalendar() || !var.status.isSelected()) continue;
            if (pred.test(var)) {
                x.add(var.getVariable(), cur);
            }
            cur += var.getVariable().getDim();
        }
        for (Variable var : this.variables) {
            if (!var.isMovingHoliday() || !var.status.isSelected()) continue;
            if (pred.test(var)) {
                x.add(var.getVariable(), cur);
            }
            cur += var.getVariable().getDim();
        }
        for (Variable var : this.variables) {
            if (!var.isOutlier() || var.status != RegStatus.Prespecified || !var.status.isSelected()) continue;
            if (pred.test(var)) {
                x.add(var.getVariable(), cur);
            }
            cur += var.getVariable().getDim();
        }
        for (Variable var : this.variables) {
            if (!var.isOutlier() || var.status == RegStatus.Prespecified || !var.status.isSelected()) continue;
            if (pred.test(var)) {
                x.add(var.getVariable(), cur);
            }
            cur += var.getVariable().getDim();
        }
        return x;
    }

    public boolean isPrespecified(IOutlierVariable ovar) {
        Variable var = this.searchVariable(ovar);
        return var == null ? false : var.status == RegStatus.Prespecified;
    }

    public ComponentType getType(ITsVariable tsvar) {
        Variable var = this.searchVariable(tsvar);
        return var == null ? ComponentType.Undefined : var.type;
    }

    public Variable searchVariable(ITsVariable tsvar) {
        Optional<Variable> found = this.variables.stream().filter(var -> var.getVariable() == tsvar).findAny();
        return found.isPresent() ? found.get() : null;
    }

    public PreadjustmentVariable searchPreadjustmentVariable(ITsVariable tsvar) {
        Optional<PreadjustmentVariable> found = this.preadjustment.stream().filter(var -> var.getVariable() == tsvar).findAny();
        return found.isPresent() ? found.get() : null;
    }

    private DataBlock[] getX(ITsVariable variable) {
        DataBlock[] x = this.xmap_.get(variable);
        if (x != null) {
            return x;
        }
        int n = this.estimationDomain_.getLength();
        x = new DataBlock[variable.getDim()];
        ArrayList<DataBlock> tmp = new ArrayList<DataBlock>();
        for (int i = 0; i < x.length; ++i) {
            x[i] = new DataBlock(n);
            tmp.add(x[i]);
        }
        variable.data(this.estimationDomain_, tmp);
        this.xmap_.put(variable, x);
        return x;
    }

    public int getRegressionVariablesStartingPosition() {
        int start = 0;
        if (this.arima_.isEstimatedMean()) {
            ++start;
        }
        if (this.missings_ != null) {
            start += this.missings_.length;
        }
        return start;
    }

    public int[] getRegressionVariablePositions(ComponentType type) {
        this.checkVariables();
        IntList x = new IntList();
        int curpos = 0;
        for (Variable var : this.variables) {
            if (!var.status.isSelected()) continue;
            int n = var.getVariable().getDim();
            if (var.type == type) {
                for (int i = 0; i < n; ++i) {
                    x.add(curpos++);
                }
                continue;
            }
            curpos += n;
        }
        return x.toArray();
    }

    public <S extends ITsVariable> int[] getRegressionVariablePositions(List<S> slist) {
        this.checkVariables();
        IntList x = new IntList();
        for (ITsVariable var : slist) {
            int i;
            int pos = this.getRegressionVariablePosition(var);
            int n = var.getDim();
            if (pos >= 0) {
                for (i = 0; i < n; ++i) {
                    x.add(pos++);
                }
                continue;
            }
            for (i = 0; i < n; ++i) {
                x.add(-1);
            }
        }
        return x.toArray();
    }

    public <S extends ITsVariable> int getRegressionVariablePosition(S s) {
        this.checkVariables();
        int curpos = 0;
        for (Variable var : this.variables) {
            if (!var.status.isSelected()) continue;
            if (s == var.getVariable()) {
                return curpos;
            }
            int n = var.getVariable().getDim();
            curpos += n;
        }
        return -1;
    }

    public RegArimaModel<SarimaModel> buildRegArima() {
        double[] y = this.getY();
        DataBlock ydata = new DataBlock(y);
        RegArimaModel<SarimaModel> regarima = new RegArimaModel<SarimaModel>(this.arima_.getModel(), ydata);
        if (this.arima_.isEstimatedMean()) {
            regarima.setMeanCorrection(true);
        } else if (this.arima_.isMean()) {
            regarima.setMeanCorrection(this.arima_.getMu().getValue());
        }
        regarima.setMissings(this.missings_);
        List<DataBlock> xdata = this.createX();
        for (DataBlock var : xdata) {
            regarima.addX(var);
        }
        return regarima;
    }

    public TsData getOriginal() {
        return this.original_.clone();
    }

    public TsDomain getSeriesDomain() {
        return this.original_.getDomain();
    }

    public TsDomain getEstimationDomain() {
        return this.estimationDomain_;
    }

    public int getFrequency() {
        return this.estimationDomain_.getFrequency().intValue();
    }

    public double[] getY() {
        if (!this.checkY()) {
            this.computeY();
        }
        return this.y_;
    }

    public TsData transformedOriginal() {
        TsData tmp = this.original_.clone();
        if (this.lp_ != LengthOfPeriodType.None) {
            new LengthOfPeriodTransformation(this.lp_).transform(tmp, null);
        }
        if (this.function_ == DefaultTransformationType.Log) {
            new LogTransformation().transform(tmp, null);
        }
        tmp.applyOnFinite(PreadjustmentVariable.regressionEffect(this.preadjustment.stream(), tmp.getDomain()), (x, y) -> x - y);
        return tmp;
    }

    public int[] getMissingValues() {
        return this.missings_;
    }

    public SarimaComponent getArimaComponent() {
        return this.arima_;
    }

    public SarimaSpecification getSpecification() {
        return this.arima_.getSpecification();
    }

    public boolean isMean() {
        return this.arima_.isMean();
    }

    public boolean isEstimatedMean() {
        return this.arima_.isEstimatedMean();
    }

    public Stream<PreadjustmentVariable> preadjustmentVariables() {
        return this.preadjustment.stream();
    }

    public boolean hasFixedEffects() {
        return !this.preadjustment.isEmpty();
    }

    public Stream<Variable> variables() {
        return this.variables.stream();
    }

    public List<Variable> getUserVariables() {
        return this.variables.stream().filter(var -> var.getVariable() instanceof IUserTsVariable).collect(Collectors.toList());
    }

    public List<Variable> getCalendars() {
        return this.selectVariables(var -> var instanceof ICalendarVariable);
    }

    protected List<Variable> getVariables() {
        return this.variables;
    }

    protected List<PreadjustmentVariable> getPreadjustmentVariables() {
        return this.preadjustment;
    }

    public List<Variable> getMovingHolidays() {
        return this.selectVariables(var -> var instanceof IMovingHolidayVariable);
    }

    public List<Variable> selectVariables(Predicate<Variable> pred) {
        return this.variables.stream().filter(pred).collect(Collectors.toList());
    }

    public List<PreadjustmentVariable> selectPreadjustmentVariables(Predicate<PreadjustmentVariable> pred) {
        return this.preadjustment.stream().filter(pred).collect(Collectors.toList());
    }

    public boolean contains(Predicate<Variable> pred) {
        return this.variables.stream().anyMatch(pred);
    }

    public int countVariables(Predicate<Variable> pred) {
        return (int)this.variables.stream().filter(pred).count();
    }

    public int countRegressors(Predicate<Variable> pred) {
        return this.variables.stream().filter(pred).mapToInt(var -> var.getVariable().getDim()).sum();
    }

    public int countFixedRegressors(Predicate<PreadjustmentVariable> pred) {
        return this.preadjustment.stream().filter(pred).mapToInt(var -> var.getVariable().getDim()).sum();
    }

    public List<IOutlierVariable> getOutliers() {
        return this.variables.stream().filter(var -> var.getVariable() instanceof IOutlierVariable && var.status != RegStatus.Prespecified).map(var -> (IOutlierVariable)var.getVariable()).collect(Collectors.toList());
    }

    public List<IOutlierVariable> getPrespecifiedOutliers() {
        return this.variables.stream().filter(var -> var.getVariable() instanceof IOutlierVariable && var.status == RegStatus.Prespecified).map(var -> (IOutlierVariable)var.getVariable()).collect(Collectors.toList());
    }

    public List<IOutlierVariable> getFixedOutliers() {
        return this.preadjustment.stream().filter(var -> var.isOutlier()).map(var -> (IOutlierVariable)var.getVariable()).collect(Collectors.toList());
    }

    public int[] getOutliersPosition(boolean prespecified) {
        List<IOutlierVariable> vars = prespecified ? this.getPrespecifiedOutliers() : this.getOutliers();
        int[] pos = new int[vars.size()];
        TsPeriod start = this.estimationDomain_.getStart();
        for (int i = 0; i < pos.length; ++i) {
            TsPeriod ostart = new TsPeriod(this.estimationDomain_.getFrequency(), vars.get(i).getPosition());
            pos[i] = ostart.minus(start);
        }
        return pos;
    }

    public int[] getFixedOutliersPosition() {
        List<IOutlierVariable> vars = this.getFixedOutliers();
        int[] pos = new int[vars.size()];
        TsPeriod start = this.estimationDomain_.getStart();
        for (int i = 0; i < pos.length; ++i) {
            TsPeriod ostart = new TsPeriod(this.estimationDomain_.getFrequency(), vars.get(i).getPosition());
            pos[i] = ostart.minus(start);
        }
        return pos;
    }

    public <T extends ITsVariable> boolean isUsed(Class<T> tclass) {
        return this.variables.stream().anyMatch(var -> tclass.isInstance(var.getVariable()) && var.status.isSelected());
    }

    public double getUnits() {
        return this.units_;
    }

    public PreadjustmentType getPreadjustmentType() {
        return this.adjust_;
    }

    public LengthOfPeriodType getLengthOfPeriodType() {
        return this.adjust_.convert(this.isUsed(ICalendarVariable.class), this.function_ == DefaultTransformationType.Log);
    }

    public DefaultTransformationType getTransformation() {
        return this.function_;
    }

    private void computeY() {
        TsData tmp = new TsData(this.estimationDomain_.getStart(), this.y0_, true);
        int len = this.y0_.length;
        this.diff_ = this.arima_.getDifferencingOrder();
        ITsDataTransformation.LogJacobian lj = new ITsDataTransformation.LogJacobian(this.diff_, len);
        this.lp_ = this.adjust_.convert(this.isUsed(ICalendarVariable.class), this.function_ == DefaultTransformationType.Log);
        if (this.lp_ != LengthOfPeriodType.None) {
            new LengthOfPeriodTransformation(this.lp_).transform(tmp, lj);
        }
        if (this.function_ == DefaultTransformationType.Log) {
            LogTransformation tlog = new LogTransformation();
            if (tlog.canTransform(tmp)) {
                tlog.transform(tmp, lj);
            } else {
                throw new TsException("Series contains values lower or equal to zero. Logs not allowed");
            }
        }
        if (!this.preadjustment.isEmpty()) {
            DataBlock all = PreadjustmentVariable.regressionEffect(this.preadjustment.stream(), this.estimationDomain_);
            tmp.apply(all, (x, y) -> x - y);
        }
        this.logtransform_ = lj.value + this.logtransform0_;
        this.y_ = tmp.internalStorage();
    }

    public void setUnit(double unit) {
        if (this.units_ != unit) {
            TsData tmp = this.original_.fittoDomain(this.estimationDomain_);
            int len = tmp.getLength();
            int diff = this.arima_.getDifferencingOrder();
            ITsDataTransformation.LogJacobian lj = new ITsDataTransformation.LogJacobian(diff, len);
            ConstTransformation.unit(this.units_).transform(tmp, lj);
            this.logtransform0_ = lj.value;
            this.y0_ = tmp.internalStorage();
            this.invalidateData();
        }
    }

    public boolean updateMissing(ITsDataInterpolator interpolator) {
        IntList missings;
        if (this.missings_ != null) {
            return false;
        }
        double[] y = (double[])this.y0_.clone();
        TsData tmp = new TsData(this.estimationDomain_.getStart(), y, false);
        if (!interpolator.interpolate(tmp, missings = new IntList(tmp.getObsCount()))) {
            return false;
        }
        if (missings.isEmpty()) {
            return true;
        }
        this.missings_ = new int[missings.size()];
        for (int i = 0; i < this.missings_.length; ++i) {
            this.missings_[i] = missings.get(i);
        }
        this.y0_ = y;
        this.invalidateData();
        return true;
    }

    @Deprecated
    public void setInterpolatedSeries(double[] y, int[] missing) {
        this.y0_ = y;
        this.missings_ = missing;
        this.invalidateData();
    }

    public void setTransformation(DefaultTransformationType fn, PreadjustmentType adjust) {
        this.function_ = fn;
        this.adjust_ = adjust;
        this.checkPreadjustment();
        this.invalidateData();
    }

    public void setTransformation(PreadjustmentType lengthOfPeriodType) {
        if (this.adjust_ != lengthOfPeriodType) {
            this.adjust_ = lengthOfPeriodType;
            this.invalidateData();
        }
    }

    public void setTransformation(DefaultTransformationType fn) {
        if (this.function_ != fn) {
            this.function_ = fn;
            this.checkPreadjustment();
            this.invalidateData();
        }
    }

    public void setPreadjustments(List<PreadjustmentVariable> var) {
        this.preadjustment.clear();
        this.preadjustment.addAll(var);
        this.invalidateData();
    }

    public void setVariables(List<Variable> var) {
        this.variables.clear();
        this.variables.addAll(var);
        this.invalidateData();
    }

    public void setArimaComponent(SarimaComponent arima) {
        this.arima_ = arima;
    }

    public void setMean(boolean mean) {
        this.arima_.setMean(mean);
    }

    public void setSpecification(SarimaSpecification spec) {
        this.arima_.setSpecification(spec);
    }

    public void setAirline(boolean seas) {
        SarimaSpecification spec = new SarimaSpecification(this.getFrequency());
        spec.airline(seas);
        this.arima_.setSpecification(spec);
    }

    public void setOutliers(List<IOutlierVariable> outliers) {
        this.variables.removeIf(var -> var.isOutlier() && var.status != RegStatus.Prespecified);
        if (outliers != null) {
            for (IOutlierVariable o : outliers) {
                this.variables.add(Variable.outlier(o));
            }
        }
    }

    public void addOutliers(List<IOutlierVariable> outliers) {
        if (outliers != null) {
            for (IOutlierVariable o : outliers) {
                this.variables.add(Variable.outlier(o));
            }
        }
    }

    public void setPrespecifiedOutliers(List<IOutlierVariable> outliers) {
        this.variables.removeIf(var -> var.isOutlier() && var.status == RegStatus.Prespecified);
        if (outliers != null) {
            for (IOutlierVariable o : outliers) {
                this.variables.add(Variable.prespecifiedOutlier(o));
            }
        }
    }

    public void addPrespecifiedOutliers(List<IOutlierVariable> outliers) {
        if (outliers != null) {
            for (IOutlierVariable o : outliers) {
                this.variables.add(Variable.prespecifiedOutlier(o));
            }
        }
    }

    public void addVariable(Variable ... var) {
        for (Variable v : var) {
            this.variables.add(v);
        }
    }

    public void addPreadjustment(PreadjustmentVariable ... var) {
        for (PreadjustmentVariable v : var) {
            this.preadjustment.add(v);
        }
    }

    public void removeVariable(Predicate<Variable> pred) {
        this.variables.removeIf(pred);
    }

    public void removePreadjustment(Predicate<PreadjustmentVariable> pred) {
        this.preadjustment.removeIf(pred);
    }

    public DataBlock getOlsResiduals() {
        Ols ols;
        RegModel dmodel = this.buildRegArima().getDModel();
        DataBlock yc = dmodel.getY();
        if (dmodel.getVarsCount() > 0 && (ols = new Ols()).process(dmodel)) {
            yc = dmodel.calcRes(new ReadDataBlock(ols.getLikelihood().getB()));
        }
        return yc;
    }

    public double getLikelihoodCorrection() {
        if (!this.checkY()) {
            this.computeY();
        }
        return this.logtransform0_ + this.logtransform_;
    }

    public List<ITsDataTransformation> transformations() {
        if (!this.checkY()) {
            this.computeY();
        }
        ArrayList<ITsDataTransformation> tr = new ArrayList<ITsDataTransformation>();
        if (this.units_ != 1.0) {
            tr.add(ConstTransformation.unit(this.units_));
        }
        if (this.lp_ != LengthOfPeriodType.None) {
            tr.add(new LengthOfPeriodTransformation(this.lp_));
        }
        if (this.function_ == DefaultTransformationType.Log) {
            tr.add(new LogTransformation());
        }
        return tr;
    }

    public List<ITsDataTransformation> backTransformations(boolean T2, boolean S) {
        if (!this.checkY()) {
            this.computeY();
        }
        ArrayList<ITsDataTransformation> tr = new ArrayList<ITsDataTransformation>();
        if (this.function_ == DefaultTransformationType.Log) {
            tr.add(new ExpTransformation());
        }
        if (S && this.lp_ != LengthOfPeriodType.None) {
            tr.add(new LengthOfPeriodTransformation(this.lp_).converse());
        }
        if (this.units_ != 1.0 && (this.function_ == DefaultTransformationType.Log || T2)) {
            tr.add(ConstTransformation.unit(1.0 / this.units_));
        }
        return tr;
    }

    private void checkPreadjustment() {
        if (this.adjust_ == PreadjustmentType.Auto && this.function_ == DefaultTransformationType.Log) {
            this.variables.stream().filter(var -> var.getVariable() instanceof ILengthOfPeriodVariable).forEach(var -> {
                var.status = RegStatus.Excluded;
            });
        }
    }

    private boolean checkY() {
        if (this.y_ == null) {
            return false;
        }
        if (this.lp_ != this.getLengthOfPeriodType()) {
            this.invalidateData();
            return false;
        }
        if (this.diff_ != this.arima_.getDifferencingOrder()) {
            this.invalidateData();
            return false;
        }
        return true;
    }

    public boolean isFullySpecified() {
        if (!this.arima_.isDefined()) {
            return false;
        }
        return this.isRegressionDefined();
    }

    public boolean isPartiallySpecified() {
        if (!this.isRegressionDefined()) {
            return false;
        }
        return !this.arima_.isUndefined();
    }

    public boolean isRegressionPrespecified() {
        if (this.function_ == DefaultTransformationType.Auto) {
            return false;
        }
        return !Variable.needTesting(this.variables);
    }

    public boolean isRegressionDefined() {
        if (this.function_ == DefaultTransformationType.Auto) {
            return false;
        }
        return Variable.isUsageDefined(this.variables);
    }
}

