/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.maths.matrices.Matrix;
import ec.tstoolkit.maths.realfunctions.FunctionException;
import ec.tstoolkit.maths.realfunctions.IFunction;
import ec.tstoolkit.maths.realfunctions.IFunctionInstance;
import ec.tstoolkit.maths.realfunctions.IFunctionMinimizer;
import ec.tstoolkit.maths.realfunctions.NumericalDerivatives;
import ec.tstoolkit.maths.realfunctions.SingleParameter;

public class GridSearch
implements IFunctionMinimizer {
    private double m_eps = 1.0E-7;
    private double m_deps = 1.0E-6;
    private double m_lbound = -1.0;
    private double m_ubound = 1.0;
    private double m_a;
    private double m_b;
    private double m_dfn;
    private double m_va;
    private double m_vb;
    private double m_x;
    private int m_nsteps0 = 30;
    private int m_nsteps1 = 4;
    private IFunction m_fn;
    private IFunctionInstance m_ftry;
    private int maxIter = 100;
    private int niter;

    private void clear() {
        this.m_ftry = null;
        this.m_fn = null;
        this.m_dfn = Double.MAX_VALUE;
        this.m_va = Double.NaN;
        this.m_vb = Double.NaN;
        this.m_x = Double.NaN;
    }

    @Override
    public IFunctionMinimizer exemplar() {
        GridSearch search = new GridSearch();
        search.m_eps = this.m_eps;
        search.m_nsteps0 = this.m_nsteps0;
        search.m_nsteps1 = this.m_nsteps1;
        search.m_lbound = this.m_lbound;
        search.m_ubound = this.m_ubound;
        return search;
    }

    @Override
    public double getConvergenceCriterion() {
        return this.m_eps;
    }

    @Override
    public Matrix getCurvature() {
        return new NumericalDerivatives(this.m_fn, this.m_ftry, false).getHessian();
    }

    @Override
    public double[] getGradient() {
        return new NumericalDerivatives(this.m_fn, this.m_ftry, false).getGradient();
    }

    public int getGridCount() {
        return this.m_nsteps1;
    }

    public int getInitialGridCount() {
        return this.m_nsteps0;
    }

    @Override
    public int getIterCount() {
        return this.niter;
    }

    public double getLBound() {
        return this.m_lbound;
    }

    @Override
    public int getMaxIter() {
        return this.maxIter;
    }

    @Override
    public IFunctionInstance getResult() {
        return this.m_ftry;
    }

    @Override
    public double getObjective() {
        return this.m_ftry == null ? Double.NaN : this.m_ftry.getValue();
    }

    public double getUBound() {
        return this.m_ubound;
    }

    private boolean iterate(int nsteps) {
        double step = (this.m_b - this.m_a) / (double)nsteps;
        double[] vals = new double[nsteps + 1];
        vals[0] = this.m_va;
        vals[nsteps] = this.m_vb;
        for (int i = 1; i < nsteps; ++i) {
            vals[i] = this.evaluate(this.m_a + (double)i * step);
        }
        double min = Double.MAX_VALUE;
        int imin = -1;
        for (int i = 0; i <= nsteps; ++i) {
            double val = vals[i];
            if (Double.isNaN(val) || !(val < min)) continue;
            imin = i;
            min = val;
        }
        if (imin == -1) {
            return false;
        }
        this.m_x = this.m_a + step * (double)imin;
        if (imin == 0) {
            this.m_b = this.m_a + step;
            this.m_vb = vals[1];
        } else if (imin == nsteps) {
            this.m_a = this.m_b - step;
            this.m_va = vals[nsteps - 1];
        } else {
            this.m_a += step * (double)(imin - 1);
            this.m_b = this.m_a + 2.0 * step;
            this.m_va = vals[imin - 1];
            this.m_vb = vals[imin + 1];
        }
        this.m_dfn = Math.abs(this.m_va - this.m_vb);
        return true;
    }

    @Override
    public boolean minimize(IFunction function, IFunctionInstance start) {
        this.clear();
        if (function.getDomain().getDim() != 1 || this.m_lbound >= this.m_ubound || this.m_nsteps0 < 3 || this.m_nsteps1 < 3) {
            return false;
        }
        this.m_fn = function;
        this.m_a = this.m_lbound;
        this.m_b = this.m_ubound;
        this.m_va = this.evaluate(this.m_a);
        this.m_vb = this.evaluate(this.m_b);
        this.niter = 0;
        while (this.niter++ < this.maxIter && this.m_b - this.m_a > this.m_deps && (Double.isNaN(this.m_dfn) || this.m_dfn > this.m_eps)) {
            if (this.iterate(this.niter == 1 ? this.m_nsteps0 : this.m_nsteps1)) continue;
            return false;
        }
        this.m_ftry = this.m_fn.evaluate(new SingleParameter(this.m_x));
        return true;
    }

    private double evaluate(double x) {
        try {
            IFunctionInstance fn = this.m_fn.evaluate(new SingleParameter(x));
            return fn.getValue();
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public void setBounds(double lb, double ub) {
        if (lb >= ub) {
            throw new FunctionException("Invalid bounds");
        }
        this.m_lbound = lb;
        this.m_ubound = ub;
    }

    @Override
    public void setConvergenceCriterion(double value) {
        this.m_eps = value;
    }

    public void setPrecision(double value) {
        this.m_deps = value;
    }

    public void setGridCount(int value) {
        this.m_nsteps1 = value;
    }

    public void setInitialGridCount(int value) {
        this.m_nsteps0 = value;
    }

    @Override
    public void setMaxIter(int n) {
        this.maxIter = n;
    }
}

