% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_workspace.R
\name{get_all_names}
\alias{get_all_names}
\title{Get the Java name of all the contained object}
\usage{
get_all_names(x)
}
\arguments{
\item{x}{An object containing other objects whose names we want to know}
}
\value{
A \code{character} vector containing all the names.
}
\description{
Generic functions to retrieve the Java name of the contained \code{multiprocessings} or the contained  \code{sa_items}.
}
\examples{
\donttest{
spec_x13 <- x13_spec(spec = "RSA5c", easter.enabled = FALSE)
sa_x13 <- x13(ipi_c_eu[, "FR"], spec = spec_x13)
spec_ts <- tramoseats_spec(spec = "RSA5")
sa_ts <- tramoseats(ipi_c_eu[, "FR"], spec = spec_ts)

wk <- new_workspace()
mp <- new_multiprocessing(wk, "sap1")
mp2 <- new_multiprocessing(wk, "sap2")

get_all_names(wk)

add_sa_item(wk, "sap1", sa_x13, "X13")
add_sa_item(wk, "sap1", sa_ts, "TramoSeats")

get_all_names(mp)
}

}
\seealso{
Other functions to retrieve information from a workspace, multiprocessing or sa_item: \code{\link{get_name}}, \code{\link{get_position}}, \code{\link{count}}, \code{\link{get_model}}, \code{\link{get_ts}}.
}
