/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.x11;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.x11.BiasCorrection;
import ec.satoolkit.x11.CalendarSigma;
import ec.satoolkit.x11.SeasonalFilterOption;
import ec.satoolkit.x11.SigmavecOption;
import ec.satoolkit.x11.TrendCycleFilterFactory;
import ec.satoolkit.x11.X11Exception;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.maths.linearfilters.SymmetricFilter;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class X11Specification
implements IProcSpecification,
Cloneable {
    public static final double DEF_LSIGMA = 1.5;
    public static final double DEF_USIGMA = 2.5;
    public static final int DEF_FCASTS = -1;
    public static final int DEF_BCASTS = 0;
    public static final String MODE = "mode";
    public static final String SEASONAL = "seasonal";
    public static final String LSIGMA = "lsigma";
    public static final String USIGMA = "usigma";
    public static final String TRENDMA = "trendma";
    public static final String SEASONALMA = "seasonalma";
    public static final String BCASTS = "bcasts";
    public static final String FCASTS = "fcasts";
    public static final String CALENDARSIGMA = "calendarsigma";
    public static final String SIGMAVEC = "sigmavec";
    public static final String EXCLUDEFCAST = "excludeforcast";
    public static final String BIAS = "bias";
    private DecompositionMode mode_ = DecompositionMode.Undefined;
    private boolean seasonal_ = true;
    private SeasonalFilterOption[] filters_;
    private double lsigma_ = 1.5;
    private double usigma_ = 2.5;
    private int henderson_ = 0;
    private int fcasts_ = -1;
    private int bcasts_ = 0;
    private CalendarSigma calendarsigma_ = CalendarSigma.None;
    private SigmavecOption[] sigmavec_;
    private boolean excludefcast_ = false;
    private BiasCorrection bias = BiasCorrection.Legacy;

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item(prefix, MODE), String.class);
        dic.put(InformationSet.item(prefix, SEASONAL), Boolean.class);
        dic.put(InformationSet.item(prefix, LSIGMA), Double.class);
        dic.put(InformationSet.item(prefix, USIGMA), Double.class);
        dic.put(InformationSet.item(prefix, TRENDMA), Integer.class);
        dic.put(InformationSet.item(prefix, SEASONALMA), String[].class);
        dic.put(InformationSet.item(prefix, FCASTS), Integer.class);
        dic.put(InformationSet.item(prefix, BCASTS), Integer.class);
        dic.put(InformationSet.item(prefix, CALENDARSIGMA), String.class);
        dic.put(InformationSet.item(prefix, SIGMAVEC), String[].class);
        dic.put(InformationSet.item(prefix, EXCLUDEFCAST), String.class);
        dic.put(InformationSet.item(prefix, BIAS), String.class);
    }

    public int getForecastHorizon() {
        return this.fcasts_;
    }

    public int getBackcastHorizon() {
        return this.bcasts_;
    }

    public int getHendersonFilterLength() {
        return this.henderson_;
    }

    public CalendarSigma getCalendarSigma() {
        return this.calendarsigma_;
    }

    public SigmavecOption[] getSigmavec() {
        return this.sigmavec_;
    }

    public double getLowerSigma() {
        return this.lsigma_;
    }

    public double getUpperSigma() {
        return this.usigma_;
    }

    public DecompositionMode getMode() {
        return this.mode_;
    }

    public SymmetricFilter getTrendFilter() {
        return TrendCycleFilterFactory.makeHendersonFilter(13);
    }

    public SeasonalFilterOption[] getSeasonalFilters() {
        return this.filters_;
    }

    public boolean isSeasonal() {
        return this.seasonal_;
    }

    public void setSeasonal(boolean seas) {
        this.seasonal_ = seas;
    }

    public boolean isExcludefcst() {
        return this.excludefcast_;
    }

    public void setExcludefcst(boolean excludefcst) {
        this.excludefcast_ = excludefcst;
    }

    public boolean isDefault() {
        int i;
        if (!this.seasonal_ || this.mode_ != DecompositionMode.Multiplicative) {
            return false;
        }
        if (this.calendarsigma_ != CalendarSigma.None) {
            return false;
        }
        if (this.fcasts_ != -1) {
            return false;
        }
        if (this.filters_ != null) {
            for (i = 0; i < this.filters_.length; ++i) {
                if (this.filters_[i] == SeasonalFilterOption.Msr) continue;
                return false;
            }
        }
        if (this.sigmavec_ != null) {
            for (i = 0; i < this.sigmavec_.length; ++i) {
                if (this.sigmavec_[i] == SigmavecOption.Group1) continue;
                return false;
            }
        }
        if (this.lsigma_ != 1.5) {
            return false;
        }
        if (this.usigma_ != 2.5) {
            return false;
        }
        if (!this.excludefcast_) {
            return false;
        }
        return this.isAutoHenderson();
    }

    public boolean isAutoHenderson() {
        return this.henderson_ <= 0;
    }

    public void setForecastHorizon(int forecastsHorizon) {
        this.fcasts_ = forecastsHorizon;
    }

    public void setBackcastHorizon(int backcastsHorizon) {
        this.bcasts_ = backcastsHorizon;
    }

    public void setCalendarSigma(CalendarSigma calendarsigma) {
        this.calendarsigma_ = calendarsigma;
    }

    public void setSigmavec(SigmavecOption[] sigmavec) {
        this.sigmavec_ = (SigmavecOption[])sigmavec.clone();
    }

    public void setMode(DecompositionMode mode) {
        this.mode_ = mode;
    }

    public void setSigma(double lsigma, double usigma) {
        if (usigma <= lsigma || lsigma <= 0.5) {
            throw new X11Exception("Invalid sigma options");
        }
        this.lsigma_ = lsigma;
        this.usigma_ = usigma;
    }

    public void setLowerSigma(double lsigma) {
        if (this.usigma_ <= lsigma) {
            this.setSigma(lsigma, lsigma + 0.5);
        } else {
            this.setSigma(lsigma, this.usigma_);
        }
    }

    public void setUpperSigma(double usigma) {
        if (usigma <= this.lsigma_) {
            this.setSigma(usigma - 0.5, usigma);
        } else {
            this.setSigma(this.lsigma_, usigma);
        }
    }

    public void setHendersonFilterLength(int len) {
        if (len < 0 || len > 101 || len != 0 && len % 2 == 0) {
            throw new X11Exception("Invalid henderson length");
        }
        this.henderson_ = len;
    }

    public void setSeasonalFilters(SeasonalFilterOption[] seasonalFilter) {
        this.filters_ = (SeasonalFilterOption[])seasonalFilter.clone();
    }

    public void setSeasonalFilter(SeasonalFilterOption seasonalFilter) {
        this.filters_ = new SeasonalFilterOption[]{seasonalFilter};
    }

    public BiasCorrection getBiasCorrection() {
        return this.bias;
    }

    public void setBiasCorrection(BiasCorrection bias) {
        this.bias = bias;
    }

    @Override
    public X11Specification clone() {
        try {
            X11Specification cspec = (X11Specification)super.clone();
            if (this.filters_ != null) {
                cspec.filters_ = (SeasonalFilterOption[])this.filters_.clone();
            }
            if (this.sigmavec_ != null) {
                cspec.sigmavec_ = (SigmavecOption[])this.sigmavec_.clone();
            }
            return cspec;
        }
        catch (CloneNotSupportedException err) {
            throw new AssertionError();
        }
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof X11Specification && this.equals((X11Specification)obj);
    }

    private boolean equals(X11Specification spec) {
        return spec.fcasts_ == this.fcasts_ && spec.bcasts_ == this.bcasts_ && Arrays.deepEquals((Object[])spec.filters_, (Object[])this.filters_) && Arrays.deepEquals((Object[])spec.sigmavec_, (Object[])this.sigmavec_) && spec.seasonal_ == this.seasonal_ && spec.henderson_ == this.henderson_ && spec.lsigma_ == this.lsigma_ && spec.usigma_ == this.usigma_ && spec.mode_ == this.mode_ && spec.calendarsigma_ == this.calendarsigma_ && spec.excludefcast_ == this.excludefcast_ && spec.bias == this.bias;
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + Objects.hashCode((Object)this.mode_);
        hash = 11 * hash + Jdk6.Double.hashCode(this.lsigma_);
        hash = 11 * hash + Jdk6.Double.hashCode(this.usigma_);
        hash = 11 * hash + this.henderson_;
        hash = 11 * hash + this.fcasts_;
        return hash;
    }

    @Override
    public InformationSet write(boolean verbose) {
        int i;
        if (!verbose && this.isDefault()) {
            return null;
        }
        InformationSet info = new InformationSet();
        if (verbose || this.mode_ != DecompositionMode.Undefined) {
            info.add(MODE, this.mode_.name());
        }
        if (verbose || !this.seasonal_) {
            info.add(SEASONAL, Boolean.valueOf(this.seasonal_));
        }
        if (verbose || this.lsigma_ != 1.5) {
            info.add(LSIGMA, Double.valueOf(this.lsigma_));
        }
        if (verbose || this.usigma_ != 2.5) {
            info.add(USIGMA, Double.valueOf(this.usigma_));
        }
        if (verbose || !this.isAutoHenderson()) {
            info.add(TRENDMA, Integer.valueOf(this.henderson_));
        }
        if (this.filters_ != null) {
            String[] filters = new String[this.filters_.length];
            for (i = 0; i < filters.length; ++i) {
                filters[i] = this.filters_[i].name();
            }
            info.add(SEASONALMA, filters);
        }
        if (verbose || this.fcasts_ != -1) {
            info.add(FCASTS, Integer.valueOf(this.fcasts_));
        }
        if (verbose || this.bcasts_ != 0) {
            info.add(BCASTS, Integer.valueOf(this.bcasts_));
        }
        if (verbose || this.calendarsigma_ != CalendarSigma.None) {
            info.add(CALENDARSIGMA, this.calendarsigma_.name());
        }
        if (this.sigmavec_ != null) {
            String[] sigmavec = new String[this.sigmavec_.length];
            for (i = 0; i < sigmavec.length; ++i) {
                sigmavec[i] = this.sigmavec_[i].name();
            }
            info.add(SIGMAVEC, sigmavec);
        }
        if (verbose || this.excludefcast_) {
            info.add(EXCLUDEFCAST, Boolean.valueOf(this.excludefcast_));
        }
        if (verbose || this.bias != BiasCorrection.Legacy) {
            info.add(BIAS, this.bias.name());
        }
        return info;
    }

    @Override
    public boolean read(InformationSet info) {
        try {
            String sbias;
            Boolean excludefcst;
            String[] sigmavec;
            String calendarsigma;
            String[] sfilters;
            Integer bcasts;
            Integer fcasts;
            Integer trendma;
            Double usig;
            Double lsig;
            Boolean seasonal;
            String mode = info.get(MODE, String.class);
            if (mode != null) {
                this.mode_ = DecompositionMode.valueOf(mode);
            }
            if ((seasonal = info.get(SEASONAL, Boolean.class)) != null) {
                this.seasonal_ = seasonal;
            }
            if ((lsig = info.get(LSIGMA, Double.class)) != null) {
                this.lsigma_ = lsig;
            }
            if ((usig = info.get(USIGMA, Double.class)) != null) {
                this.usigma_ = usig;
            }
            if ((trendma = info.get(TRENDMA, Integer.class)) != null) {
                this.henderson_ = trendma;
            }
            if ((fcasts = info.get(FCASTS, Integer.class)) != null) {
                this.fcasts_ = fcasts;
            }
            if ((bcasts = info.get(BCASTS, Integer.class)) != null) {
                this.bcasts_ = bcasts;
            }
            if ((sfilters = info.get(SEASONALMA, String[].class)) != null) {
                this.filters_ = new SeasonalFilterOption[sfilters.length];
                for (int i = 0; i < sfilters.length; ++i) {
                    this.filters_[i] = SeasonalFilterOption.valueOf(sfilters[i]);
                }
            }
            if ((calendarsigma = info.get(CALENDARSIGMA, String.class)) != null) {
                this.calendarsigma_ = CalendarSigma.valueOf(calendarsigma);
            }
            if ((sigmavec = info.get(SIGMAVEC, String[].class)) != null) {
                this.sigmavec_ = new SigmavecOption[sigmavec.length];
                for (int i = 0; i < sigmavec.length; ++i) {
                    this.sigmavec_[i] = SigmavecOption.valueOf(sigmavec[i]);
                }
            }
            if ((excludefcst = info.get(EXCLUDEFCAST, Boolean.class)) != null) {
                this.excludefcast_ = excludefcst;
            }
            this.bias = (sbias = info.get(BIAS, String.class)) != null ? BiasCorrection.valueOf(sbias) : BiasCorrection.Legacy;
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }
}

