/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class CompactDataParser {
    private static final String sourceClass = CompactDataParser.class.getSimpleName();
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String SERIES = "Series";
    private static final String OBS = "Obs";

    public static List<PortableTimeSeries> parse(InputStreamReader inputStreamReader, DataFlowStructure dataFlowStructure, String string) throws XMLStreamException, UnsupportedEncodingException {
        logger.entering(sourceClass, "parse");
        ArrayList<PortableTimeSeries> arrayList = new ArrayList<PortableTimeSeries>();
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        XMLEventReader xMLEventReader = xMLInputFactory.createXMLEventReader(inputStreamReader);
        PortableTimeSeries portableTimeSeries = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                Iterator<Attribute> iterator;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == SERIES) {
                    logger.finer("Got new time series");
                    portableTimeSeries = new PortableTimeSeries();
                    portableTimeSeries.setDataflow(string);
                    iterator = xMLEvent.getAttributes();
                    CompactDataParser.setMetadata(portableTimeSeries, dataFlowStructure, iterator);
                }
                if (xMLEvent.getName().getLocalPart().equals(OBS)) {
                    xMLEvent2 = xMLEventReader.nextEvent();
                    logger.finest(xMLEvent2.toString());
                    iterator = xMLEvent.getAttributes();
                    String string2 = null;
                    String string3 = null;
                    String string4 = "";
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        if (attribute.getName().toString().equals(dataFlowStructure.getTimeDimension())) {
                            string2 = attribute.getValue();
                            continue;
                        }
                        if (attribute.getName().toString().equals(dataFlowStructure.getObsStatus())) {
                            string4 = attribute.getValue();
                            continue;
                        }
                        if (!attribute.getName().toString().equals(dataFlowStructure.getMeasure())) continue;
                        string3 = attribute.getValue();
                    }
                    if (string2 != null && !string2.isEmpty() && string3 != null && !string3.isEmpty()) {
                        portableTimeSeries.addObservation(new Double(string3), string2, string4);
                        continue;
                    }
                    throw new RuntimeException("Error during CompactData Parsing. Invalid Observation Time: " + string2 + " or value: " + string3);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES || portableTimeSeries.getObservations().size() <= 0) continue;
            logger.finer("Adding time series " + portableTimeSeries);
            arrayList.add(portableTimeSeries);
        }
        logger.exiting(sourceClass, "parse");
        return arrayList;
    }

    private static void setMetadata(PortableTimeSeries portableTimeSeries, DataFlowStructure dataFlowStructure, Iterator<Attribute> iterator) {
        logger.entering(sourceClass, "setMetadata");
        String[] stringArray = new String[dataFlowStructure.getDimensions().size()];
        while (iterator.hasNext()) {
            Attribute attribute = iterator.next();
            String string = attribute.getName().toString();
            String string2 = attribute.getValue();
            if (dataFlowStructure.isDimension(string)) {
                stringArray[dataFlowStructure.getDimensionPosition((String)string) - 1] = string + "=" + string2;
                if (string.equalsIgnoreCase("FREQ") || string.equalsIgnoreCase("FREQUENCY")) {
                    portableTimeSeries.setFrequency(string2);
                }
            } else {
                portableTimeSeries.addAttribute(attribute.toString());
            }
            portableTimeSeries.setDimensions(Arrays.asList(stringArray));
        }
        logger.exiting(sourceClass, "setMetadata");
    }
}

