/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.DataCache;
import it.bancaditalia.oss.sdmx.client.MetadataCache;
import it.bancaditalia.oss.sdmx.client.ObservationMetadataCache;
import it.bancaditalia.oss.sdmx.client.SdmxClientHandler;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.SdmxException;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SASClientHandler
extends SdmxClientHandler {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static DataCache data = null;
    private static MetadataCache metadata = null;
    private static ObservationMetadataCache obsmetadata = null;

    public static String makeGetDimensions(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            List<Dimension> list = SdmxClientHandler.getDimensions(string, string2);
            for (Dimension dimension : list) {
                stringBuilder.append(dimension.getId());
                stringBuilder.append(",");
            }
        }
        catch (Exception exception) {
            logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
            logger.log(Level.FINER, "", exception);
        }
        return stringBuilder.length() > 0 ? stringBuilder.substring(0, stringBuilder.length() - 1) : "";
    }

    public static int makeGetTimeSeries(String string, String string2, String string3, String string4) {
        int n;
        block12: {
            n = 0;
            data = null;
            metadata = null;
            obsmetadata = null;
            try {
                int n2;
                List<PortableTimeSeries> list = SdmxClientHandler.getTimeSeries(string, string2, string3, string4);
                if (list.isEmpty()) break block12;
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                for (PortableTimeSeries portableTimeSeries : list) {
                    n2 = portableTimeSeries.getObservations().size();
                    n3 += n2;
                    n4 += portableTimeSeries.getDimensions().size();
                    n4 += portableTimeSeries.getAttributes().size();
                    n5 += portableTimeSeries.getObsLevelAttributesNames().size() * n2;
                }
                data = new DataCache(n3);
                metadata = new MetadataCache(n4);
                obsmetadata = new ObservationMetadataCache(n5);
                int n6 = 0;
                int n7 = 0;
                n2 = 0;
                for (PortableTimeSeries portableTimeSeries : list) {
                    String string5;
                    String string6;
                    String[] stringArray;
                    Object object;
                    String string7 = portableTimeSeries.getName();
                    List<String> list2 = portableTimeSeries.getDimensions();
                    for (String string8 : list2) {
                        object = string8.split("\\s*=\\s*");
                        stringArray = object[0];
                        string6 = object[1];
                        metadata.setRow(n7, string7, (String)stringArray, string6, "DIMENSION");
                        ++n7;
                    }
                    List<String> list3 = portableTimeSeries.getAttributes();
                    Iterator iterator = list3.iterator();
                    while (iterator.hasNext()) {
                        object = (String)iterator.next();
                        stringArray = object.split("\\s*=\\s*");
                        string6 = stringArray[0];
                        string5 = stringArray[1];
                        metadata.setRow(n7, string7, string6, string5, "ATTRIBUTE");
                        ++n7;
                    }
                    String[] stringArray22 = portableTimeSeries.getTimeSlotsArray();
                    if (stringArray22.length != ((String[])(object = portableTimeSeries.getObservationsArray())).length) {
                        logger.warning("The time series " + string7 + " is not well formed. Skip it.");
                        break;
                    }
                    for (int i = 0; i < stringArray22.length; ++i) {
                        string6 = stringArray22[i];
                        string5 = object[i];
                        if (n6 <= data.size()) {
                            data.setRow(n6, string7, string6, (Double)((Object)string5));
                            List<String> list4 = portableTimeSeries.getObsLevelAttributesNames();
                            for (String string9 : list4) {
                                String[] stringArray2 = portableTimeSeries.getObsLevelAttributesArray(string9);
                                if (stringArray22.length != stringArray2.length) {
                                    logger.warning("The observation level attributes: " + string9 + " for time series " + string7 + " are not well set. Skip them.");
                                    break;
                                }
                                String string10 = stringArray2[i];
                                obsmetadata.setRow(n2, string7, string9, string10, string6);
                                ++n2;
                            }
                        } else {
                            throw new SdmxException("Unexpected error during Time Series pocessing in SasHandler.");
                        }
                        ++n6;
                    }
                }
                n = list.size();
            }
            catch (Exception exception) {
                logger.severe("Exception. Class: " + exception.getClass().getName() + " .Message: " + exception.getMessage());
                logger.log(Level.FINER, "", exception);
                data = null;
                metadata = null;
                n = -1;
            }
        }
        return n;
    }

    public static String getMetaName(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getName((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaKey(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getKey((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaValue(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getValue((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getMetaType(double d) throws SdmxException {
        if (metadata != null && d <= (double)metadata.size()) {
            return metadata.getType((int)d);
        }
        throw new SdmxException("Metadata cache error: cache is null or index exceeds size.");
    }

    public static double getDataObservation(double d) throws SdmxException {
        if (data != null && d <= (double)data.size()) {
            return data.getObservation((int)d);
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    public static String getDataTimestamp(double d) throws SdmxException {
        if (data != null && d <= (double)data.size()) {
            return data.getTimestamp((int)d);
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    public static String getDataName(double d) throws SdmxException {
        if (data != null && d <= (double)data.size()) {
            return data.getName((int)d);
        }
        throw new SdmxException("Data cache error: cache is null or index exceeds size.");
    }

    public static int getNumberOfMeta() {
        if (metadata != null) {
            return metadata.size();
        }
        return 0;
    }

    public static int getNumberOfObsMeta() {
        if (obsmetadata != null) {
            return obsmetadata.size();
        }
        return 0;
    }

    public static int getNumberOfData() {
        if (data != null) {
            return data.size();
        }
        return 0;
    }

    public static String getObsMetaName(double d) throws SdmxException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getName((int)d);
        }
        throw new SdmxException("Observation level Metadata cache error: cache is null or index exceeds size.");
    }

    public static String getObsMetaKey(double d) throws SdmxException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getKey((int)d);
        }
        throw new SdmxException("Observation level  cache error: cache is null or index exceeds size.");
    }

    public static String getObsMetaValue(double d) throws SdmxException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getValue((int)d);
        }
        throw new SdmxException("Observation level  cache error: cache is null or index exceeds size.");
    }

    public static String getObsMetaDate(double d) throws SdmxException {
        if (obsmetadata != null && d <= (double)obsmetadata.size()) {
            return obsmetadata.getDate((int)d);
        }
        throw new SdmxException("Observation level  cache error: cache is null or index exceeds size.");
    }
}

