/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.helper;

import it.bancaditalia.oss.sdmx.helper.Mapper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public class CheckboxListTableModel<T>
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;

    public CheckboxListTableModel(String string, String string2) {
        this.setColumnCount(3);
        this.setColumnIdentifiers(new String[]{"", string, string2});
        this.setRowCount(0);
    }

    public void setItems(Map<String, String> map) {
        this.setRowCount(0);
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.addRow(new Object[]{Boolean.FALSE, entry.getKey(), entry.getValue()});
            }
        }
    }

    public void setItems(List<T> list, Mapper<T> mapper) {
        this.setRowCount(0);
        if (list != null && list.size() > 0) {
            for (T t : list) {
                Object[] objectArray = new Object[]{Boolean.FALSE, null, null};
                System.arraycopy(mapper.toMapEntry(t), 0, objectArray, 1, 2);
                this.addRow(objectArray);
            }
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n == 0 ? Boolean.class : String.class;
    }

    public Collection<String> getCheckedCodes() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Vector vector : this.getDataVector()) {
            if (!((Boolean)vector.get(0)).booleanValue()) continue;
            linkedList.add((String)vector.get(1));
        }
        return linkedList;
    }

    public void uncheckAll() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.setValueAt(false, i, 0);
        }
    }
}

