/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.Dimension;
import it.bancaditalia.oss.sdmx.api.Message;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.RestSdmxClient;
import it.bancaditalia.oss.sdmx.event.DataFooterMessageEvent;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.parser.v21.CompactDataParser;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.parser.v30.AvailabilityParser;
import it.bancaditalia.oss.sdmx.parser.v30.Sdmx30Queries;
import it.bancaditalia.oss.sdmx.parser.v30.SeriesCountParser;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.SSLSocketFactory;

public class RestSdmx30Client
extends RestSdmxClient {
    protected final String LATEST_VERSION = "+";

    public RestSdmx30Client(String string, URI uRI, SSLSocketFactory sSLSocketFactory, boolean bl, boolean bl2, boolean bl3) {
        super(string, uRI, sSLSocketFactory, bl, bl2, bl3);
        this.sdmxVersion = "SDMX_V3";
        this.latestKeyword = this.LATEST_VERSION;
    }

    public RestSdmx30Client(String string, URI uRI, boolean bl, boolean bl2, boolean bl3) {
        this(string, uRI, null, bl, bl2, bl3);
        this.sdmxVersion = "SDMX_V3";
        this.latestKeyword = this.LATEST_VERSION;
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        return this.getTimeSeries(dataflow, dataFlowStructure, string, null, string2, string3, bl, string4, bl2);
    }

    @Override
    public List<PortableTimeSeries<Double>> getTimeSeries(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException {
        return this.postProcess(this.getData(dataflow, dataFlowStructure, string, string2, string3, string4, bl, string5, bl2));
    }

    @Override
    public Map<String, List<String>> getAvailableCubeRegion(Dataflow dataflow, String string, String string2) throws SdmxException {
        URL uRL = this.buildAvailabilityQuery(dataflow, string, string2);
        return this.runQuery(new AvailabilityParser(), uRL, null, null);
    }

    @Override
    public Integer getAvailableTimeSeriesNumber(Dataflow dataflow, String string) throws SdmxException {
        URL uRL = this.buildAvailabilityQueryByKey(dataflow, string, "exact");
        return this.runQuery(new SeriesCountParser(), uRL, null, null);
    }

    protected DataParsingResult getData(Dataflow dataflow, DataFlowStructure dataFlowStructure, String string, String object, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        String string5;
        DataParsingResult dataParsingResult;
        Message message;
        Object object2;
        if (string != null && !string.isEmpty()) {
            if (string.contains("+")) {
                object2 = this.mapSDMX2KeytoSDMX3FIlter(string, dataFlowStructure);
                object = object != null && !((String)object).isEmpty() ? (String)object + "&" + (String)object2 : object2;
                string = null;
            } else {
                string = string.replace("..", ".*.").replace("..", ".*.");
            }
        }
        if ((message = (dataParsingResult = this.runQuery(new CompactDataParser(dataFlowStructure, dataflow, !bl), (URL)(object2 = this.buildDataQuery(dataflow, string, (String)object, string2, string3, bl, string4, bl2)), "application/vnd.sdmx.structurespecificdata+xml;version=2.1", string5 = "data_" + dataflow.getId() + "_" + (String)object)).getMessage()) != null) {
            LOGGER.log(Level.INFO, "The sdmx call returned messages in the footer:\n {0}", message);
            DataFooterMessageEvent dataFooterMessageEvent = new DataFooterMessageEvent((URL)object2, message);
            this.dataFooterMessageEventListener.onSdmxEvent(dataFooterMessageEvent);
        }
        return dataParsingResult;
    }

    private String mapSDMX2KeytoSDMX3FIlter(String string, DataFlowStructure dataFlowStructure) throws SdmxInvalidParameterException {
        String string2 = "";
        Dimension[] dimensionArray = (Dimension[])dataFlowStructure.getDimensions().toArray();
        String string3 = "[.]";
        String[] stringArray = string.split(string3);
        if (stringArray.length > dimensionArray.length) {
            throw new SdmxInvalidParameterException("The ts key is not valid: the dataflow does not contain so many dimensions.");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].isEmpty() || stringArray[i].equals("*")) continue;
            string2 = string2 + (!string2.isEmpty() ? "&" : "") + "c[" + dimensionArray[i].getId() + "]=" + stringArray[i].replace("+", ",");
        }
        return string2;
    }

    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, String string4, boolean bl, String string5, boolean bl2) throws SdmxException {
        if (this.endpoint != null && dataflow != null) {
            return Sdmx30Queries.createDataQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2, string3, string4, bl, string5, bl2).buildQuery();
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " endpoint=" + this.endpoint);
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.endpoint != null && string2 != null && !string2.isEmpty() && string != null && !string.isEmpty()) {
            return Sdmx30Queries.createStructureQuery(this.endpoint, string, string2, string3, bl).buildQuery();
        }
        throw new RuntimeException("Invalid query parameters: agency=" + string2 + " dsd=" + string + " endpoint=" + this.endpoint);
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx30Queries.createDataflowQuery(this.endpoint, string, string2, string3).buildQuery();
    }

    @Override
    protected URL buildCodelistQuery(String string, String string2, String string3) throws SdmxException {
        return Sdmx30Queries.createCodelistQuery(this.endpoint, string, string2, string3).buildQuery();
    }

    protected URL buildAvailabilityQuery(Dataflow dataflow, String string, String string2) throws SdmxException {
        return Sdmx30Queries.createAvailabilityQuery(this.endpoint, dataflow.getFullIdentifier(), string, string2).buildQuery();
    }

    protected URL buildAvailabilityQueryByKey(Dataflow dataflow, String string, String string2) throws SdmxException {
        return Sdmx30Queries.createAvailabilityQueryByKey(this.endpoint, dataflow.getFullIdentifier(), string, string2).buildQuery();
    }
}

