/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.client.custom;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.client.Provider;
import it.bancaditalia.oss.sdmx.client.custom.RestSdmx20Client;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.exceptions.SdmxExceptionFactory;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.parser.v21.Sdmx21Queries;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.RestQueryBuilder;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;

public class IMF2
extends RestSdmx20Client {
    protected static Logger logger = Configuration.getSdmxLogger();

    public IMF2(Provider provider) throws URISyntaxException {
        super(provider, "", null);
    }

    @Override
    protected URL buildFlowQuery(String string, String string2, String string3) throws SdmxException {
        if (this.provider.getEndpoint() != null) {
            try {
                return new RestQueryBuilder(this.provider.getEndpoint()).addPath("Dataflow").build();
            }
            catch (MalformedURLException malformedURLException) {
                throw SdmxExceptionFactory.wrap(malformedURLException);
            }
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: endpoint=" + this.provider.getEndpoint());
    }

    @Override
    protected URL buildDSDQuery(String string, String string2, String string3, boolean bl) throws SdmxException {
        if (this.provider.getEndpoint() != null && string != null && !string.isEmpty()) {
            try {
                return new RestQueryBuilder(this.provider.getEndpoint()).addPath("DataStructure").addPath(string).build();
            }
            catch (MalformedURLException malformedURLException) {
                throw SdmxExceptionFactory.wrap(malformedURLException);
            }
        }
        throw new SdmxInvalidParameterException("Invalid query parameters: dsd=" + string + " endpoint=" + this.provider.getEndpoint());
    }

    @Override
    protected URL buildDataQuery(Dataflow dataflow, String string, String string2, String string3, boolean bl, String string4, boolean bl2) throws SdmxException {
        if (this.provider.getEndpoint() != null && dataflow != null && string != null && !string.isEmpty()) {
            return ((Sdmx21Queries)new Sdmx21Queries(this.provider.getEndpoint()).addPath("CompactData").addPath(dataflow.getDsdIdentifier().getId()).addPath(string)).addParams(string2, string3, bl, string4, bl2, this.format).buildSdmx21Query();
        }
        throw new RuntimeException("Invalid query parameters: dataflow=" + dataflow + " resource=" + string + " endpoint=" + this.provider.getEndpoint());
    }
}

