/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.util;

import it.bancaditalia.oss.sdmx.api.BaseObservation;
import it.bancaditalia.oss.sdmx.api.DoubleObservation;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.exceptions.SdmxInvalidParameterException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import java.util.Iterator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public class Utils {
    private Utils() {
    }

    public static void checkString(String string, String string2) throws SdmxInvalidParameterException {
        if (string == null || string.isEmpty()) {
            Configuration.getSdmxLogger().severe("The name of the provider cannot be null");
            throw new SdmxInvalidParameterException(string2);
        }
    }

    public static double[] toDoubleArray(PortableTimeSeries<?> portableTimeSeries) {
        double[] dArray = new double[portableTimeSeries.size()];
        for (int i = 0; i < portableTimeSeries.size(); ++i) {
            dArray[i] = ((BaseObservation)portableTimeSeries.get(i)).getValueAsDouble();
        }
        return dArray;
    }

    public static PortableTimeSeries<Double> mapToDoubleValues(PortableTimeSeries<?> portableTimeSeries) {
        PortableTimeSeries<Double> portableTimeSeries2 = new PortableTimeSeries<Double>(portableTimeSeries);
        for (BaseObservation<?> baseObservation : portableTimeSeries) {
            portableTimeSeries2.add(new DoubleObservation(baseObservation, baseObservation.getValueAsDouble()));
        }
        return portableTimeSeries2;
    }

    public static PortableTimeSeries<Double> combineValuesAsDouble(PortableTimeSeries<Double> portableTimeSeries, PortableTimeSeries<Double> portableTimeSeries2, DoubleBinaryOperator doubleBinaryOperator) {
        if (portableTimeSeries.size() != portableTimeSeries2.size()) {
            throw new UnsupportedOperationException("The two series do not have the same size.");
        }
        PortableTimeSeries<Double> portableTimeSeries3 = new PortableTimeSeries<Double>(portableTimeSeries);
        Iterator<BaseObservation<Double>> iterator = portableTimeSeries2.iterator();
        for (BaseObservation<Double> baseObservation : portableTimeSeries) {
            portableTimeSeries3.add(new DoubleObservation(baseObservation, doubleBinaryOperator.applyAsDouble(baseObservation.getValueAsDouble(), iterator.next().getValueAsDouble())));
        }
        return portableTimeSeries3;
    }

    public static PortableTimeSeries<Double> mapValuesAsDouble(PortableTimeSeries<Double> portableTimeSeries, DoubleUnaryOperator doubleUnaryOperator) {
        PortableTimeSeries<Double> portableTimeSeries2 = new PortableTimeSeries<Double>(portableTimeSeries);
        for (BaseObservation<Double> baseObservation : portableTimeSeries) {
            portableTimeSeries2.add(new DoubleObservation(baseObservation, doubleUnaryOperator.applyAsDouble(baseObservation.getValueAsDouble())));
        }
        return portableTimeSeries2;
    }
}

